% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/si.R
\name{si}
\alias{si}
\title{Calculate a Serial Interval Distribution}
\usage{
si(ndays, shape, rate, leading0 = TRUE)
}
\arguments{
\item{ndays}{Integer, the number of days over which to calculate the
serial interval distribution.}

\item{shape}{Numeric, the shape parameter of the gamma distribution.}

\item{rate}{Numeric, the rate parameter of the gamma distribution.}

\item{leading0}{Logical, should a leading 0 be added to indicate t0?}
}
\value{
Numeric vector representing the serial interval probabilities
for each of the first \code{ndays} days. The probabilities are normalized
so that their sum is 1.
}
\description{
This function computes the probability distribution function (PDF) of the
serial interval using a gamma distribution with specified
shape and rate parameters. The serial interval is defined as the time
between successive cases in a chain of transmission. This implementation
generates a discrete PDF at the \emph{daily} level.
}
\details{
The function uses the \code{pgamma} function to calculate cumulative
probabilities for each day up to \code{ndays} and then differences these
to get daily probabilities. The resulting probabilities are normalized to
sum to 1, ensuring that they represent a valid probability distribution.
}
\examples{
si(ndays = 14, shape = 4.29, rate = 1.18)
}
