% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/convert_to_linelist.R
\name{convert_to_linelist}
\alias{convert_to_linelist}
\title{Convert Case Counts to a Line List}
\usage{
convert_to_linelist(
  caseCounts,
  reportF_missP,
  reportF = NULL,
  reportF_args = NULL
)
}
\arguments{
\item{caseCounts}{A data frame with columns \code{date}, \code{cases}, and \code{location}.
The data frame must meet several criteria:
- It should only contain data for one location.
- Dates must be in Date format.
- Case numbers must be non-negative integers.
- No missing values are allowed in the necessary columns.}

\item{reportF_missP}{A numeric probability between 0 and 1 (exclusive) indicating the
proportion of missing onset dates. It throws an error if it is out
of bounds or not numeric.}

\item{reportF}{A function used to simulate the delay from case reporting to case onset.
Defaults to a negative binomial distribution function (\code{rnbinom}) if NULL.}

\item{reportF_args}{A list of additional arguments to pass to \code{reportF}.
Defaults to \code{list(size = 3, mu = 9)} when \code{reportF} is NULL.}
}
\value{
A data frame in line list format, where each row corresponds to a case report.
The data frame includes columns for the report date, the delay from report to onset,
the onset date, weekend indicator, report interval in days from the first report,
and week interval.
The returned data frame has additional attributes set, including \code{min_day} and the
class \code{lineList}.
}
\description{
This function takes a data frame of case counts and expands it into a line list format,
which is often used for epidemiological analysis. The function validates input data,
manages missingness, and assumes additional generation times based on the specified
reporting function.
}
\details{
The function stops and sends error messages for various data integrity issues,
such as incorrect data types, negative cases, or missing required columns.
It also assumes that the input data is for only one location and handles
NA generation according to \code{reportF_missP}.
}
\examples{
data("sample_dates")
data("sample_location")
data("sample_cases")
case_Counts <- create_caseCounts(sample_dates, sample_location, sample_cases)
line_list <- convert_to_linelist(case_Counts, reportF_missP = 0.5)
}
