% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/webpower.R
\name{wp.sem.rmsea}
\alias{wp.sem.rmsea}
\title{Statistical Power Analysis for Structural Equation Modeling based on RMSEA}
\usage{
wp.sem.rmsea(n = NULL, df = NULL, rmsea0 = NULL, rmsea1 = NULL,
  power = NULL, alpha = 0.05, type = c("close", "notclose"))
}
\arguments{
\item{n}{Sample size.}

\item{df}{Degrees of freedom. The degrees of freedom of the chi-squared test.}

\item{rmsea0}{RMSEA for H0. It usually euquals zero.}

\item{rmsea1}{RMSEA for H1.}

\item{power}{Statistical power.}

\item{alpha}{significance level chosed for the test. It equals 0.05 by default.}

\item{type}{Close fit or non-clase fit (\code{'close'} or \code{'notclose'}). It is 'close' by default.}
}
\value{
An object of the power analysis.
}
\description{
Structural equation modeling (SEM) is a multivariate technique used to analyze relationships among observed and latent variables.
It can be viewed as a combination of factor analysis and multivariate regression analysis.
Two methods are widely used in power analysis for SEM. One is based on the likelihood ratio test proposed by \cite{Satorra and Saris (1985)}.
The other is based on RMSEA proposed by \cite{MacCallum et al. (1996)}. 
This function is for SEM power analysis based on RMSEA.
}
\examples{
#To calculate the statistical power given sample size and effect size:
wp.sem.rmsea (n = 100, df = 4, rmsea0 = 0,
               rmsea1 = 0.116,  power = NULL, alpha = 0.05)
#    Power for SEM based on RMSEA
#  
#        n df rmsea0 rmsea1     power alpha
#      100  4      0  0.116 0.4208173  0.05
#  
#    URL: http://psychstat.org/rmsea

#To generate a power curve given a sequence of sample sizes:
res <- wp.sem.rmsea (n = seq(100,600,100), df = 4, rmsea0 = 0,
                        rmsea1 = 0.116,  power = NULL, alpha = 0.05)
res
#    Power for SEM based on RMSEA
#  
#        n df rmsea0 rmsea1     power alpha
#      100  4      0  0.116 0.4208173  0.05
#      200  4      0  0.116 0.7494932  0.05
#      300  4      0  0.116 0.9135968  0.05
#      400  4      0  0.116 0.9746240  0.05
#      500  4      0  0.116 0.9933963  0.05
#      600  4      0  0.116 0.9984373  0.05
#  
#    URL: http://psychstat.org/rmsea

#To plot the power curve:
plot(res) 

#To calculate the required sample size given power and effect size:
wp.sem.rmsea (n = NULL, df = 4, rmsea0 = 0,
              rmsea1 = 0.116,  power = 0.8, alpha = 0.05)
#    Power for SEM based on RMSEA
#  
#             n df rmsea0 rmsea1 power alpha
#      222.7465  4      0  0.116   0.8  0.05
#  
#    URL: http://psychstat.org/rmsea

#  #To calculate the minimum detectable effect size of rmsea1 given power and sample size:
wp.sem.rmsea (n = 100, df = 4, rmsea0 = 0,
             rmsea1 = NULL,  power = 0.8, alpha = 0.05)
#    Power for SEM based on RMSEA
#  
#        n df rmsea0    rmsea1 power alpha
#      100  4      0 0.1736082   0.8  0.05
#  
#    URL: http://psychstat.org/rmsea
}
\references{
MacCallum, R. C., Browne, M. W., & Sugawara, H. M. (1996). Power analysis and determination of sample size for covariance structure modeling. Psychological methods, 1(2), 130.

Zhang, Z., & Yuan, K.-H. (2018). Practical Statistical Power Analysis Using Webpower and R (Eds). Granger, IN: ISDSA Press.
}
