% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/idMapping.R, R/idToSymbol.R
\name{idMapping}
\alias{idMapping}
\alias{IDMapping}
\alias{idToSymbol}
\title{ID Mapping}
\usage{
idMapping(organism = "hsapiens", dataType = "list",
  inputGeneFile = NULL, inputGene = NULL, sourceIdType,
  targetIdType = NULL, collapseMethod = "mean",
  mappingOutput = FALSE, outputFileName = "",
  hostName = "http://www.webgestalt.org/")

idToSymbol(organism = "hsapiens", dataType = "list",
  inputGeneFile = NULL, inputGene = NULL,
  sourceIdType = "ensembl_gene_id", collapseMethod = "mean",
  mappingOutput = FALSE, outputFileName = NULL,
  hostName = "http://www.webgestalt.org/")
}
\arguments{
\item{organism}{Currently, WebGestaltR supports 12 organisms. Users can use the function
\code{listOrganism} to check available organisms. Users can also input \code{others} to
perform the enrichment analysis for other organisms not supported by WebGestaltR. For
other organisms, users need to provide the functional categories, interesting list and
reference list (for ORA method). Because WebGestaltR does not perform the ID mapping for
the other organisms, the above data should have the same ID type.}

\item{dataType}{Type of data, either \code{list}, \code{rnk} or \code{gmt}.
Could be \code{list}, \code{rnk} or \code{matrix} for \code{idToSymbol}.}

\item{inputGeneFile}{The data file to be mapped.}

\item{inputGene}{Or the input could be given as an R object.
GMT file should be read with \code{readGmt}.}

\item{sourceIdType}{The ID type of the data.}

\item{targetIdType}{The ID type of the mapped data.}

\item{collapseMethod}{The method to collapse duplicate IDs with scores. \code{mean},
\code{median}, \code{min} and \code{max} represent the mean, median, minimum and maximum
of scores for the duplicate IDs.}

\item{mappingOutput}{Boolean if the mapping output is written to file.}

\item{outputFileName}{The output file name.}

\item{hostName}{The server URL for accessing data. Mostly for development purposes.}
}
\value{
A list of \code{mapped} and \code{unmapped} IDs.
}
\description{
ID mapping utility with WebGestalt server.
}
