% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_win_fft.R
\name{plot_win_fft}
\alias{plot_win_fft}
\title{Plot windowed fft based spectral analysis results}
\usage{
plot_win_fft(
  win_fft = NULL,
  x_lab = c("depth (m)"),
  y_lab = c("frequency cycle/metre"),
  plot_res = 1,
  perc_vis = 0,
  freq_max = NULL,
  freq_min = NULL,
  keep_editable = FALSE,
  palette_name = "rainbow",
  color_brewer = "grDevices",
  plot_horizontal = TRUE,
  dev_new = TRUE
)
}
\arguments{
\item{win_fft}{list which is the results of the \code{\link{win_fft}}}

\item{x_lab}{label for the y-axis \code{Default="depth"}}

\item{y_lab}{label for the y-axis \code{Default="sedrate"}}

\item{plot_res}{plot 1 of 8 options option 1: Amplitude matrix,
option 2: Power matrix,
option 3: Phase matrix,
option 4: AR1_CL matrix,
option 5: AR1_Fit matrix ,
option 6: AR1_90_power matrix,
option 7: AR1_95_power matrix,
option 8: AR1_99_power matrix, \code{Default=1}}

\item{perc_vis}{Cutoff percentile when plotting \code{Default=0}}

\item{freq_max}{Maximum frequency to plot}

\item{freq_min}{Minimum frequency to plot}

\item{keep_editable}{Keep option to add extra features after plotting  \code{Default=FALSE}}

\item{palette_name}{Name of the color palette which is used for plotting.
The color palettes than can be chosen depends on which the R package is specified in
the color_brewer parameter. The included R packages from which palettes can be chosen
from are; the 'RColorBrewer', 'grDevices', 'ColorRamps' and 'Viridis' R packages.
There are many options to choose from so please
read the documentation of these packages \code{Default=rainbow}.
The R package 'viridis' has the color palette options: “magma”, “plasma”,
“inferno”, “viridis”, “mako”, and “rocket”  and “turbo”
To see the color palette options of the The R pacakge 'RColorBrewer' run
the RColorBrewer::brewer.pal.info() function
The R package 'colorRamps' has the color palette options:"blue2green",
"blue2green2red", "blue2red",    "blue2yellow", "colorRamps",    "cyan2yellow",
"green2red", "magenta2green", "matlab.like", "matlab.like2" and    "ygobb"
The R package 'grDevices' has the built in  palette options:"rainbow",
"heat.colors", "terrain.colors","topo.colors" and "cm.colors"
To see even more color palette options of the The R pacakge 'grDevices' run
the grDevices::hcl.pals() function}

\item{color_brewer}{Name of the R package from which the color palette is chosen from.
The included R packages from which palettes can be chosen
are; the RColorBrewer, grDevices, ColorRamps and Viridis R packages.
There are many options to choose from so please
read the documentation of these packages. "\code{Default=grDevices}}

\item{plot_horizontal}{plot the wavelet horizontal or vertical eg y axis is depth or y axis power  \code{Default=TRUE}}

\item{dev_new}{Opens a new plotting window to plot the plot, this guarantees  a "nice" looking plot however when plotting in an R markdown
document the plot might not plot  \code{Default=TRUE}}
}
\value{
Returns a plot of, which plot 1 of 8 options,
option 1: Amplitude matrix
option 2: Power matrix
option 3: Phase matrix
option 4: AR1_CL matrix
option 5: AR1_Fit matrix
option 6: AR1_90_power matrix
option 7: AR1_95_power matrix
option 8: AR1_99_power matrix
}
\description{
The \code{\link{plot_win_fft}} function allows for the (re)plotting of the results of the \code{\link{win_fft}}
}
\examples{
\donttest{
#Conduct a windowed fft on the magnetic susceptibility record \cr
# of the Sullivan core of Pas et al., (2018).

mag_win_fft <- win_fft(data= mag,
                   padfac = 5,
                   window_size = 12.5,
                   run_multicore = FALSE,
                   genplot = FALSE,
                   palette_name = "rainbow",
                   color_brewer="grDevices",
                   x_lab = c("depth (m)"),
                   y_lab = c("frequency cycle/meter"),
                   plot_res = 1,
                   perc_vis = 0.5,
                   freq_max = 5,
                   freq_min = 0.001,
                   keep_editable=FALSE,
                   verbose=FALSE)

# Plot the amplitude spectra
plot_win_fft(win_fft= mag_win_fft,
x_lab = c("depth (m)"),
y_lab = c("frequency cycle/meter"),
plot_res = 1,
perc_vis = 0.5,
freq_max = 5,
freq_min = 0.001,
keep_editable=FALSE,
palette_name = "rainbow",
color_brewer="grDevices",
plot_horizontal=TRUE,
dev_new=TRUE)

}

}
