% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/AddSites.R
\name{AddSites}
\alias{AddSites}
\title{AddSites}
\usage{
AddSites(server, username, password, sites)
}
\arguments{
\item{server}{The URL of the web service ending with /services or with ?wsdl,
for example: http://worldwater.byu.edu/app/index.php/default/services/cuahsi_1_1.asmx?wsdl
alternatively you can specify the JSON API url like:
http://worldwater.byu.edu/app/index.php/default/services/api/}

\item{username}{The valid HydroServer Lite username, for example "admin"}

\item{password}{The valid HydroServer Lite password, for example "password"}

\item{sites}{The valid table of sites. This table must have the following 4 columns:
SiteCode, SiteName, Latitude, Longitude. It can also have the optional columns:
Elevation, SiteType, State, County, Comments.}
}
\value{
A table of the added sites, with two extra columns:
SiteID (the ID assigned by the server),
Status (the status showing if the site was added: OK or Error). If the status is Error, then
the Error message with reason why the site could not be added is also shown.
}
\description{
This function adds a table of sites to HydroServer Lite.
The input must be a data.frame with all required ODM site fields
NOTE: this only works with HydroServer Lite that implements the JSON API.
you must specify a valid server url, user name, and password for the HydroServer.
The examples here use the 'sandbox' HydroServer on http://worldwater.byu.edu/app/
with the username: admin and password: password.
}
\examples{
user <- "admin"
pass <- "password"
server <- "http://worldwater.byu.edu/app/index.php/default/services/cuahsi_1_1.asmx"
#make random site codes
random_codes = sprintf("\%04d",sample(1:10000, 2))
random_names = paste("R","Upload", random_codes)
random_lats = runif(2, 35.0, 49.0) #two random latitudes inside U.S
random_lons = runif(2, -110.0, -70.0) #random longitudes inside U.S
my_sites <- data.frame(SiteCode=random_codes, SiteName=random_names,
                       Latitude=random_lats, Longitude=random_lons)

added_sites <- AddSites(server, username=user, password=pass, sites=my_sites)
}
\keyword{waterml}

