% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ROC.R
\name{ROCPlotPair}
\alias{ROCPlotPair}
\title{Plot two receiver operating characteristic from the same data.frame.}
\usage{
ROCPlotPair(frame, xvar1, xvar2, truthVar, truthTarget, title, ...,
  returnScores = FALSE, nrep = 100, parallelCluster = NULL)
}
\arguments{
\item{frame}{data frame to get values from}

\item{xvar1}{name of the first independent (input or model) column in frame}

\item{xvar2}{name of the second independent (input or model) column in frame}

\item{truthVar}{name of the dependent (output or result to be modeled) column in frame}

\item{truthTarget}{value we consider to be positive}

\item{title}{title to place on plot}

\item{...}{no unnamed argument, added to force named binding of later arguments.}

\item{returnScores}{logical if TRUE return detailed permutedScores}

\item{nrep}{number of permutation repititions to estimate p values.}

\item{parallelCluster}{(optional) a cluster object created by package parallel or package snow.}
}
\description{
Plot two receiver operating characteristic from the same data.frame.
}
\examples{

set.seed(34903490)
x1 = rnorm(50)
x2 = rnorm(length(x1))
y = 0.2*x2^2 + 0.5*x2 + x1 + rnorm(length(x1))
frm = data.frame(x1=x1,x2=x2,yC=y>=as.numeric(quantile(y,probs=0.8)))
# WVPlots::ROCPlot(frm, "x1", "yC", TRUE, title="Example ROC plot")
# WVPlots::ROCPlot(frm, "x2", "yC", TRUE, title="Example ROC plot")
WVPlots::ROCPlotPair(frm, "x1", "x2", "yC", TRUE,
   title="Example ROC pair plot")

}

