% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ScatterBoxPlot.R
\name{ScatterBoxPlotH}
\alias{ScatterBoxPlotH}
\title{Plot a scatter plot in horizontal mode.
xvar is the continuous variable and yvar is the discrete variable (input or model) and}
\usage{
ScatterBoxPlotH(frm, xvar, yvar, title = "", ..., pt_alpha = 0.3)
}
\arguments{
\item{frm}{data frame to get values from}

\item{xvar}{name of the continuous column in frame}

\item{yvar}{name of the independent column in frame; assumed discrete.
if frm[[yvar]] is an integer column, it will be converted to a factor. This means that
additional layers that rely on continuous x scales (like geom_smooth) won't work}

\item{title}{plot title}

\item{...}{(doesn't take additional arguments, used to force later arguments by name)}

\item{pt_alpha}{transparency of points in scatter plot}
}
\description{
Plot a scatter plot in horizontal mode.
xvar is the continuous variable and yvar is the discrete variable (input or model) and
}
\examples{

classes = c("a", "b", "c")
means = c(2, 4, 3)
names(means) = classes
label = sample(classes, size=1000, replace=TRUE)
meas = means[label] + rnorm(1000)
frm2 = data.frame(label=label,
                  meas = meas)
WVPlots::ScatterBoxPlotH(frm2, "meas", "label",  pt_alpha=0.2, title="Example Scatter/Box plot")


}

