% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DebugFn.R
\name{DebugFn}
\alias{DebugFn}
\title{Capture arguments of exception throwing plot for later debugging.}
\usage{
DebugFn(saveFile, fn, ...)
}
\arguments{
\item{saveFile}{path to save RDS to.}

\item{fn}{function to call}

\item{...}{arguments for fn}
}
\value{
fn(...) normally, but if f(...) throws an exception save to saveFile RDS of list r such that do.call(r$fn,r$args) repeats the call to fn with args.
}
\description{
Run fn, save arguments on failure.
}
\examples{

d <- data.frame(x=1:5)
DebugFn('problem.RDS','PlotDistCountNormal',d,xvar='x','example')
tryCatch(
   DebugFn('problem.RDS','PlotDistCountNormal',
      d,xvar='xmisspelled','example'),
   error = function(e) { print(e) })

}

