% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fitplot.R
\name{fitplot}
\alias{fitplot}
\alias{fitplot.tidal}
\alias{fitplot.tidalmean}
\title{Plot the fitted results for a tidal object}
\usage{
fitplot(dat_in, ...)

\method{fitplot}{tidal}(dat_in, tau = NULL, predicted = TRUE,
  annuals = TRUE, logspace = TRUE, dt_rng = NULL, col_vec = NULL,
  grids = TRUE, min_mo = 9, mo_strt = 10, pretty = TRUE, lwd = 1,
  size = 2, alpha = 1, ...)

\method{fitplot}{tidalmean}(dat_in, predicted = TRUE, annuals = TRUE,
  logspace = TRUE, dt_rng = NULL, col_vec = NULL, grids = TRUE,
  min_mo = 9, mo_strt = 10, pretty = TRUE, lwd = 1, size = 2,
  alpha = 1, ...)
}
\arguments{
\item{dat_in}{input tidal or tidalmean object}

\item{...}{arguments passed to other methods}

\item{tau}{numeric vector of quantiles to plot, defaults to all in object if not supplied}

\item{predicted}{logical indicating if standard predicted values are plotted, default \code{TRUE}, otherwise normalized predictions are plotted}

\item{annuals}{logical indicating if plots are annual aggregations of results}

\item{logspace}{logical indicating if plots are in log space}

\item{dt_rng}{Optional chr string indicating the date range of the plot. Must be two values in the format 'YYYY-mm-dd' which is passed to \code{\link{as.Date}}.}

\item{col_vec}{chr string of plot colors to use, passed to \code{\link{gradcols}}.  Any color palette from RColorBrewer can be used as a named input. Palettes from grDevices must be supplied as the returned string of colors for each palette.}

\item{grids}{logical indicating if grid lines are present}

\item{min_mo}{numeric value from one to twelve indicating the minimum number of months with observations for averaging by years, applies only if \code{annuals = TRUE}.  See \code{\link{annual_agg}}.}

\item{mo_strt}{numeric indicating month to start aggregation years, defaults to October for USGS water year from October to September, applies only if \code{annuals = TRUE}.  See \code{\link{annual_agg}}.}

\item{pretty}{logical indicating if my subjective idea of plot aesthetics is applied, otherwise the \code{\link[ggplot2]{ggplot}} default themes are used}

\item{lwd}{numeric value indicating width of lines}

\item{size}{numeric value indicating size of points}

\item{alpha}{numeric value indicating transparency of points or lines}
}
\value{
A \code{\link[ggplot2]{ggplot}} object that can be further modified
}
\description{
Plot a tidal object to view response variable observations, predictions, and normalized results.
}
\examples{

## load a fitted tidal object
data(tidfit)

# plot using defaults
fitplot(tidfit)

# get the same plot but use default ggplot settings
fitplot(tidfit, pretty = FALSE)

# plot in log space
fitplot(tidfit, logspace = TRUE)

# plot specific quantiles
fitplot(tidfit, tau = c(0.1, 0.9))

# plot the normalized predictions
fitplot(tidfit, predicted = FALSE)

# plot as monthly values
fitplot(tidfit, annuals = FALSE) 

# format the x-axis is using annual aggregations
library(ggplot2)

fitplot(tidfit, annual = TRUE) + 
 scale_x_date(limits = as.Date(c('2000-01-01', '2012-01-01')))

# modify the plot as needed using ggplot scales, etc.

fitplot(tidfit, pretty = FALSE, linetype = 'dashed') + 
 theme_classic() + 
 scale_y_continuous(
   'Chlorophyll', 
   limits = c(0, 50)
   ) +
 scale_colour_manual( 
   'Predictions', 
   labels = c('lo', 'md', 'hi'), 
   values = c('red', 'green', 'blue'), 
   guide = guide_legend(reverse = TRUE)
   ) 
 
# plot a tidalmean object
data(tidfitmean)

fitplot(tidfitmean)  
}
\seealso{
\code{\link{fitmoplot}}, \code{\link{prdnrmplot}}, \code{\link{sliceplot}}
}
