% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/all_sims.R
\name{all_sims}
\alias{all_sims}
\title{Simulate a response variable time series using all functions}
\usage{
all_sims(dat_in, ...)
}
\arguments{
\item{dat_in}{input \code{\link[base]{data.frame}} that must include discharge and decimal time columns, see example dataset \code{\link{daydat}}}

\item{...}{additional arguments passed to \code{\link{lnres_sim}}}
}
\value{
Original data frame with additional columns for simulated discharge (\code{lnQ_sim}), the random errors of the response variable (\code{errs}), the standard error estimates for each residual (\code{scls}), a flow-independent response variable time series (\code{lnres_noQ}), and a flow-dependent time series (\code{lnres_Q}).
}
\description{
Simulate a response variable time series using all simulation functions
}
\details{
This is a convenience function that combines \code{\link{lnQ_sim}}, \code{\link{lnres_err}}, and \code{\link{lnres_sim}}.  See the help documentation function for more details on each.
}
\examples{
\dontrun{
## example data
data(daydat)

## simulate
tmp <- all_sims(daydat)
}
}
\seealso{
\code{\link{daydat}} for example data, \code{\link{lnQ_sim}} for simulating discharge, \code{\link{lnres_err}} for estimating the error structure of the response variable, and \code{\link{lnres_sim}} for simulating the response variable
}
