% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/samplesize.R
\name{WMWssp_maximize}
\alias{WMWssp_maximize}
\title{Maximizing power for a given Type I error rate and prior information x and y}
\usage{
WMWssp_maximize(x, y, alpha = 0.05, N)
}
\arguments{
\item{x}{a vector of prior information for the first group}

\item{y}{a vector of prior information for the second group}

\item{alpha}{Type I error rate}

\item{N}{total sample size}
}
\value{
Returns an object from class WMWssp containing

\item{result}{A dataframe with the results.}

\item{t}{The optimal allocation rate.}

\item{alpha}{The type-I error rate which was used.}

\item{power}{The maximized power.}

\item{N}{The total sample size which was used.}
}
\description{
This function maximizes the power of the Wilcoxon-Mann-Whitney test for a given total sample size N and type-I error rate with respect to the allocation rate t = n_1/N.
}
\examples{
# Prior information for the reference group
x <- c(315,375,356,374,412,418,445,403,431,410,391,475,379)
# generate data for treatment group based on a shift effect
y <- x - 20

#
N <- 112

# calculate optimal t
ssp <- WMWssp_maximize(x, y, alpha = 0.05, N)
summary(ssp)
}
\references{
Brunner, E., Bathke A. C. and Konietschke, F. Rank- and Pseudo-Rank Procedures in Factorial Designs - Using R and SAS. Springer Verlag. to appear.

Happ, M., Bathke, A. C., & Brunner, E. (2019). Optimal Sample Size Planning for the Wilcoxon-Mann-Whitney-Test. Statistics in medicine, 38(3), 363-375.
}
\keyword{export}
