% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/contour.RVineMatrix.R, R/plot.RVineMatrix.R
\name{contour.RVineMatrix}
\alias{contour.RVineMatrix}
\alias{plot.RVineMatrix}
\title{Plotting \code{RVineMatrix} objects.}
\usage{
\method{contour}{RVineMatrix}(x, tree = "ALL", xylim = NULL, cex.nums = 1, data = NULL, ...)

\method{plot}{RVineMatrix}(
  x,
  tree = "ALL",
  type = 0,
  edge.labels = NULL,
  legend.pos = "bottomleft",
  interactive = FALSE,
  ...
)
}
\arguments{
\item{x}{\code{RVineMatrix} object.}

\item{tree}{\code{"ALL"} or integer vector; specifies which trees are
plotted.}

\item{xylim}{numeric vector of length 2; sets \code{xlim} and \code{ylim}
for the contours}

\item{cex.nums}{numeric; expansion factor for font of the numbers.}

\item{data}{a data matrix for creating kernel density contours of each pair.}

\item{\dots}{Arguments passed to
\code{\link[network:plot.network]{network::plot.network()}} or
\code{\link[=plot.BiCop]{plot.BiCop()}} respectively.}

\item{type}{integer; specifies how to make use of variable names: \cr
\code{0} = variable names are ignored, \cr \code{1} = variable names are
used to annotate vertices, \cr \code{2} = uses numbers in plot and adds a
legend for variable names.}

\item{edge.labels}{character; either a vector of edge labels or one of the
following: \cr \code{"family"} = pair-copula family abbreviation (see
\code{\link[=BiCopName]{BiCopName()}}), \cr \code{"par"} =
pair-copula parameters, \cr \code{"tau"} = pair-copula Kendall's tau (by
conversion of parameters) \cr \code{"family-par"} = pair-copula family and
parameters \cr \code{"family-tau"} = pair-copula family and Kendall's tau.}

\item{legend.pos}{the \code{x} argument for
\code{\link[graphics:legend]{graphics::legend()}}.}

\item{interactive}{logical; if TRUE, the user is asked to adjust the
positioning of vertices with his mouse.}
}
\description{
There are two plotting generics for \code{RVineMatrix} objects.
\code{plot.RVineMatrix} plots one or all trees of a given R-vine copula
model. Edges can be labeled with information about the corresponding
pair-copula. \code{contour.RVineMatrix} produces a matrix of contour plots
(using \code{\link[=plot.BiCop]{plot.BiCop()}}).
}
\details{
If you want the contour boxes to be perfect squares, the plot height should
be \code{1.25/length(tree)*(d - min(tree))} times the plot width.
}
\examples{

## build vine model
strucmat <- matrix(c(3,   1, 2, 0, 2, 1, 0, 0, 1), 3, 3)
fammat   <- matrix(c(0,   1, 6, 0, 0, 3, 0, 0, 0), 3, 3)
parmat   <- matrix(c(0, 0.3, 3, 0, 0, 1, 0, 0, 0), 3, 3)
par2mat  <- matrix(c(0,   0, 0, 0, 0, 0, 0, 0, 0), 3, 3)
RVM  <- RVineMatrix(strucmat, fammat, parmat, par2mat)

# plot trees
\dontrun{plot(RVM)}

# show contour plots
contour(RVM)

}
\seealso{
\code{\link[=RVineMatrix]{RVineMatrix()}},
\code{\link[network:plot.network]{network::plot.network()}},
\code{\link[=plot.BiCop]{plot.BiCop()}},
\code{\link[=BiCopName]{BiCopName()}},
\code{\link[graphics:legend]{graphics::legend()}}
}
\author{
Thomas Nagler, Nicole Barthel
}
\keyword{plot}
