% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/visielse.r
\name{visielse}
\alias{visielse}
\title{Function \code{visielse}}
\usage{
visielse(X, book = NULL, is.ViSibook = FALSE, doplot = TRUE,
  Xsup = NULL, method = "global", group = NULL, grwithin = NULL,
  informer = "median", tests = TRUE, threshold.test = 0.01,
  quantity = "N", pixel = 20, t_0 = 0, sorted.line = TRUE,
  decrgr2 = FALSE, max_tps = NULL, colvect = NULL, ncolvect = NULL,
  times = FALSE, timeformat = c("hh:mm:ss"), idsubject = 1)
}
\arguments{
\item{X}{A \code{data.frame} or \code{matrix}. \code{X} stores punctual action realization times.
The actions are defined in \code{book}, and X columns names should correspond to the slot "vars" of \code{book}.
X must also have a column to identify individuals.}

\item{book}{A \code{data.frame} or a \code{ViSibook} or NULL.  \code{book} stores the process structure. \itemize{
 \item{ If it is a \code{data.frame} it should contains at least the columns \strong{vars, label, typeA, showorder, deb, fin }.
Optionally other characteristics can be filled : \strong{GZDebn,  GZFin, Repetition, BZBeforeDeb, BZBeforeFin, BZAfterDeb, BZAfterFin, BZLong , BZLtype }.}
\item{ If it is a \code{ViSibook} it should correspond to the columns names of X.}
\item{ If it is \code{NULL} the process is the ordered list of punctual actions given by the columns names of X.}
}}

\item{is.ViSibook}{A logical \itemize{ \item{ \code{FALSE} if book is a \code{data.frame} or \code{NULL}}. \item{ \code{TRUE} is book is a ViSibook.}}}

\item{doplot}{A logical If \code{FALSE} the graphic is not plotted.}

\item{Xsup}{A \code{data.frame} or \code{matrix} storing supplementary time data,  \strong{all individuals in}  \code{Xsup}  \strong{must be in } \code{X}.}

\item{method}{In \{ \code{"global"} ,  \code{"cut"} ,  \code{"join"} , \code{"within"} \}.
\code{method} specifies the plotting method, see \code{details}. If \code{group} is \code{NULL},
 \code{method} is set to \code{"global"}.}

\item{group}{A \code{factor} with two \code{levels}.
\code{group} indicates the group attributed to the individuals,
it has same the length as the number of rows of \code{X}.}

\item{grwithin}{A level of \code{group}.
If \code{method} is set to \code{within}, \code{grwithin} specifies the group to consider.}

\item{informer}{In \{ "\code{NULL}" , "\code{median}" , "\code{mean}" \}.
If \code{informer} is set
to "median" the median and quartiles are computed,
if it is set to "mean" the  mean and standard deviation are. If \code{informer} is \code{NULL} no indicators are computed.}

\item{tests}{A boolean.
When \code{informer} is not NULL and \code{group} is defined, if \code{tests} is \code{TRUE}, tests are computed to compare groups.
If the parameter \code{informer} is set to "\code{mean}",
the function \code{wilcox.test()} is used, if \code{informer} is set to "\code{median}" the function \code{mood.test()} is used.}

\item{threshold.test}{A numeric between 0 and  1.
\code{threshold.test} is the value of the p-value under which the H0 hypothesis
 of the test is rejected when \code{tests} is \code{TRUE}.}

\item{quantity}{In \{ "\code{N}" , "\code{dens}" \}. \code{quantity} allows choosing the quantity represented for punctual action
When \code{quantity} is set to "N" the number of individuals is considered. Otherwise when it
is set to "dens" proportion of individuals is considered instead. If \code{group} is defined and
\code{method} set to "cut" or "within", this proportion is calculated regarding each represented group.}

\item{pixel}{An integer.
It is the number of unit of time under which individuals are aggregated in the plot.}

\item{t_0}{either 0, either a value of the slot "\code{vars}" in \code{book},
\code{t_0} indicates the starting time to plot.}

\item{sorted.line}{A boolean.
When \code{sorted.line} is \code{TRUE}, it allows long actions to be sorted by starting time.}

\item{decrgr2}{A boolean. When sorted.line is TRUE and decrgr2 is TRUE, long actions of the second group are plotted in decreasing order by starting times.}

\item{max_tps}{A numeric, \code{>0}. \code{max_tps} is the maximum time used to build the grid in the plot.
\code{max_tps} is useful when \code{Xsup} is given. If \code{max_tps} is \code{NULL} it is automatically computed.}

\item{colvect}{A \code{matrix} containing colors.
Colors are automatically computed if \code{colvect} is \code{NULL}.
If \code{group} is not \code{NULL} colvect should have two rows otherwise one.}

\item{ncolvect}{A \code{numeric}.
\code{ncolvect} indicates the number of columns of \code{colvect}. Its default setting is \code{dim(X)[1]}.
\code{ncolvect} is considered only if \code{colvect} is \code{NULL}.}

\item{times}{A boolean. If \code{times} is \code{TRUE}, it indicates that \code{X} contains data in a time format.}

\item{timeformat}{time format.  If \code{times} is \code{TRUE}.}

\item{idsubject}{An integer between 1 and \code{dim(X)[2]}.  \code{idsubject} indicates the
number of the column of X that contains individuals id numbers.}
}
\value{
a ViSigrid object.
}
\description{
\code{visielse} plots the graphic from data and build an object class
\code{ViSigrid} with at least data of times of individual execution
for each punctual action defined in the \code{ViSibook}.
}
\details{
\itemize{
\item{ \code{method} }{   \itemize{
 \item{ \code{global} }{:  The plot of the ViSigrid object returned will not consider the parameter \code{group} and plot indistinctly all individuals. }
 \item{ \code{cut} }{: In the plot of the ViSigrid object returned each group will be plotted apart within each action line. }
 \item{  \code{join} }{: In the plot of the ViSigrid object returned groups will be plotted gathered within each action line. }
 \item{\code{within}}{ : In the plot of the ViSigrid object returned , within each action line, there will be two lines,
as for the method \code{cut}, the difference is that the first line will plot all individuals and
the second one individuals belonging to the group specified in \code{grwithin}. }
 } }
\item{ \code{informer}}{

The parameter \code{informer} allows choosing an indicator. \code{informer} can take three values:
\itemize{
\item{ \code{median}:}{ Median and quartiles are calculated for each action, using the function
quantile from the package stats. This is the default value.}
\item{\code{mean}:}{ Mean and standard deviation are calculated for each action, using the
functions mean and var from the package stats.}
\item{\code{NULL}:}{ no indicators are computed.}
}
When a group is declared indicators are calculated by group if the method cut or
within is chosen.

When plotting the \code{\linkS4class{ViSigrid}} object, indicators for a punctual action are represented by
white circles linked by a line. For long action, only a black line is plotted from
the median (or mean) of the punctual action staring it. The line length represents
the median (or mean) of the long action duration.
Informers are computed directly on the given matrix for punctual action.
And for a long action it is calculated on the difference between the beginning punctual action and the ending one.
}
\item{ \code{tests} and \code{threshold.test}}{

As for the parameter informer, tests are computed on the given
matrix or data.frame X for a punctual action. And for a long action it is calculated on its difference between its beginning and ending punctual actions.
In  \code{\link{plot-ViSigrid-method}}, results of the tests are represented by a star only when the
 resulted p-value is bellow or equal to the parameter threshold.test.
}
\item{ \code{pixel}}{

The parameter pixel represents the number of unit of time under which individuals
are aggregated for punctual action in the plot. When the parameter pixel is too
small the information represented will be too much aggregated to allow interpretation.

For punctual actions data are aggregated in a matrix \eqn{M} . The number of row of \eqn{M} is the
number of action and its number of columns is  \eqn{[ ( max(X)-t_{0} )/pixel]}.

\eqn{M_{i,j}} contains the number of observations of the \eqn{i}-th punctual action (by the order
of the ViSibook object) between \eqn{t_0 + (j-1)pixel} included and
\eqn{t_0 + j*pixel} excluded.
}
\item{ \code{t_0}}{

The origin of the graphic can be set using the parameter t_0. There is two ways to define it:
\itemize{
\item{A number:}{  set to 0__. It can be change at convenience, but for long actions black zones will not
be drawn, and for punctual actions black and green zones will not be translated.}
\item{The name of a punctual action:}{ To set the origin of the graphic to the moment
 when the action was done for each individual. Black and green zones will not be translated as well.}
}
}

}

x can also has the columns : GZDebn,  GZFin, Repetition, BZBeforeDeb, BZBeforeFin, BZAfterDeb, BZAfterFin, BZLong , BZLtype
}
\examples{
coffee <- c(  58, 11,  5, 53, 53, 59, 24, 59, 46, 20)
fill_coffee <- c(162,  57,103,154,165,132,  74, 107, 104,  93)
fill_water <- c(  66,  92,54, 78, 74, 114, 91, 129, 71, 56)
push_B <- c( 74, 99, 62, 84, 83, 120, 95, 129, 80, 63 )
drink <- c( 472, 176, 475, 283, 265, 207, 234, 184, 490, 520)
X <- data.frame(id = seq(1,10), coffee, fill_coffee,fill_water,push_B,drink)
library(ViSiElse)
visi1 <- visielse(X)

#### Changing the pixel of time

visi1 <- visielse(X, pixel = 10)
# Plot the mean and standart deviation

visi1 <- visielse(X,informer = "mean")

#### Do not plot indicators
visi1 <- visielse(X,informer = NULL)


# Extraction of the visibook from the data

visi1 <- visielse(X,informer = NULL, doplot = FALSE)
book <- visi1@book
plot(book)

#### Changing labels

book[,2]<- c("Taking the coffee",
             "Fill the machine with coffee",
             "Fill the tank with water",
             "Push the Button",
             "Drink the coffee")
plot(book)
visi1 <- visielse(X, book=book, is.ViSibook = TRUE,informer = NULL)


#### Change the order of Actions in the process

book[,4]<- c(5,1,2,4,3)
plot(book)
visi1 <- visielse(X, book=book, is.ViSibook = TRUE)



#### Adding a long Actions

visi1 <- visielse( X )
book <- ConvertFromViSibook( visi1@book ) # Convert book into data.frame
add_delay <- c( "delay_coffee_push","Preparation","l","6","coffee","push_B")
book[6,] <- add_delay
book


### ViSiElse representation of long actions

visi2 <- visielse( X=X , book=book,informer=NULL)

## Green & Black zones

book$GZDeb <- c(NA,60,NA,NA,NA,NA)
book$GZFin <- c(NA,120,NA,NA,NA,NA)
book$BZBeforeDeb <- c(NA,0,NA,NA,NA,NA)
book$BZBeforeFin <- c(NA,30,NA,NA,NA,NA)
book$BZAfterDeb <- c(NA,180,NA,NA,NA,NA)
book$BZAfterFin <- c(NA,Inf,NA,NA,NA,NA)
book$BZLong <- c(rep(NA,5),150)
book$BZLtype <- c(rep(NA,5),"time")
visi1 <- visielse( X, book=book , informer = NULL)

book$BZLtype <- c(rep(NA,5),"span")
visi1 <- visielse( X, book=book ,informer = NULL)


## Group

### Method : Cut
group <- c( "group2","group1","group2","group1","group1",
             "group2","group1","group1","group1","group2")
visi1 <- visielse( X,group=group, book=book ,informer = NULL, method = "cut")

visi1 <- visielse( X,group=group, book=book ,informer = NULL, method = "join")

visi1 <- visielse( X,group=group, book=book ,informer = NULL, method = "within",grwithin = "group1")
}
\seealso{
Classes \code{\linkS4class{ViSigrid}} and \code{\linkS4class{ViSibook}}.
 The method plot for ViSigrid object \code{\link{plot-ViSigrid-method}} for examples.
}
