% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/roots.R
\name{03. Roots}
\alias{03. Roots}
\alias{sqrt.vli}
\alias{sqrtrem}
\alias{sqrtrem.default}
\alias{sqrtrem.numeric}
\alias{sqrtrem.vli}
\alias{rootk}
\alias{rootk.default}
\alias{rootk.numeric}
\alias{rootk.vli}
\alias{rootkrem}
\alias{rootkrem.default}
\alias{rootkrem.numeric}
\alias{rootkrem.vli}
\title{Integer roots for vli Objects}
\usage{
\method{sqrt}{vli}(x)

sqrtrem(x)

\method{sqrtrem}{default}(x)

\method{sqrtrem}{numeric}(x)

\method{sqrtrem}{vli}(x)

rootk(x, k)

\method{rootk}{default}(x, k)

\method{rootk}{numeric}(x, k)

\method{rootk}{vli}(x, k)

rootkrem(x, k)

\method{rootkrem}{default}(x, k)

\method{rootkrem}{numeric}(x, k)

\method{rootkrem}{vli}(x, k)
}
\arguments{
\item{x}{base of the root; object of class vli or 32 bits integer}

\item{k}{index of the root; object of class vli or 32 bits integer}
}
\value{
object of class vli
}
\description{
Computation of integer roots and their remainders of vli (Very Large Integers) objects. Functions \code{sqrt} and \code{rootk} returns respectively the integer square root and the integer k-th root of the given value. Functions \code{sqrtrem} and \code{rootkrem} returns the corresponding remainder.
}
\examples{
x <- as.vli("4124135")
sqrt(x)
sqrtrem(x)
sqrt(x)^2 + sqrtrem(x) == x
rootk(as.vli("1492346293864978561249785"), 5)
}
\author{
Javier Leiva Cuadrado
}
