% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/loop_em.R
\name{loop_em}
\alias{loop_em}
\title{The EM loop for the main mean and variance function}
\usage{
loop_em(meanmodel, theta.old, p.old, x.0, X, maxit, eps)
}
\arguments{
\item{meanmodel}{Dataframe containing only the covariates to be fit in the mean model. NULL for zero mean model and FALSE for constant mean model.}

\item{theta.old}{Vector containing the initial variance parameter estimates to be fit in the variance model.}

\item{p.old}{Vector of length n containing the containing the initial variance estimate.}

\item{x.0}{Matrix of covariates (length n) to be fit in the variance model. All have been rescaled so zero is the minimum. If NULL, then its a constant variance model.}

\item{X}{Vector of length n of the outcome variable.}

\item{maxit}{Number of maximum iterations for the EM algorithm.}

\item{eps}{Very small number for the convergence criteria.}
}
\value{
A list of the results from the EM algorithm, including
\itemize{
\item\code{conv}: Logical argument indicating if convergence occurred
\item\code{it}: Total iterations performed of the EM algorithm
 \item\code{reldiff}: the positive convergence tolerance that occured at the final iteration.
 \item\code{theta.new}: Vector of variance parameter estimates. Note that these are not yet
 transformed back to the appropriate scale
 \item\code{mean}: Vector of mean parameter estimates
 \item\code{fittedmean}: Vector of fitted mean estimates
 \item\code{p.old}: Vector of fitted variance estimates
 }
}
\description{
\code{loop_em} is a basic EM loop function to be utilised by various other higher level functions.
}
