% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/datasets.R
\name{get_cov_data}
\alias{get_cov_data}
\title{Get datasets from Vancouver Open Data Portal}
\usage{
get_cov_data(
  dataset_id,
  format = c("csv", "geojson"),
  select = "*",
  where = NULL,
  apikey = getOption("VancouverOpenDataApiKey"),
  rows = NULL,
  cast_types = TRUE,
  refresh = FALSE
)
}
\arguments{
\item{dataset_id}{Dataset id from the Vancouver Open Data catalogue}

\item{format}{`csv` or `geojson` are supported at this time (default `csv`)}

\item{select}{select string for fields to return, returns all fields by default.
It accepts \href{https://help.opendatasoft.com/apis/ods-search-v2/#select-clause}{ODSQL syntax}.}

\item{where}{Query parameter to filter data (default `NULL` no filter)
It accepts \href{https://help.opendatasoft.com/apis/ods-search-v2/#where-clause}{ODSQL syntax}.}

\item{apikey}{Vancouver Open Data API key, default `getOption("VancouverOpenDataApiKey")`}

\item{rows}{Maximum number of rows to return (default `NULL` returns all rows)}

\item{cast_types}{Logical, use metadata to look up types and type-cast automatically, default `TRUE`}

\item{refresh}{refresh cached data, default `FALSE``}
}
\value{
tibble or sf object data table output, depending on the value of the `format` parameter
}
\description{
Get datasets from Vancouver Open Data Portal
}
\examples{
# Get all parking tickets issued at the 1100 block of Alberni Street between 2017 and 2019
\dontrun{
get_cov_data("parking-tickets-2017-2019",where = "block = 1100 AND street = 'ALBERNI ST'")
}

}
