\name{kumloglogis}
\alias{dkumloglogis}
\alias{pkumloglogis}
\alias{varkumloglogis}
\alias{eskumloglogis}
\title{Kumaraswamy log-logistic distribution}
\description{Computes the pdf, cdf, value at risk and expected shortfall for the Kumaraswamy log-logistic distribution due to de Santana et al. (2012) given by
\deqn{\begin{array}{ll}
&\displaystyle
f (x) =  \frac {a b \beta \alpha^\beta x^{a \beta - 1}}
{\left( \alpha^\beta + x^\beta \right)^{a + 1}}
\left[ 1 - \frac {x^{a \beta}}{\left( \alpha^\beta + x^\beta \right)^a} \right]^{b - 1},
\\
&\displaystyle
F (x) =  \left[ 1 - \frac {x^{a \beta}}{\left( \alpha^\beta + x^\beta \right)^a} \right]^b,
\\
&\displaystyle
{\rm VaR}_p (X) = \alpha \left\{ \left[ 1 - (1 - p)^{1 / b} \right]^{1 / a} - 1 \right\}^{-1 / \beta},
\\
&\displaystyle
{\rm ES}_p (X) = \frac {\alpha}{p} \int_0^p \left\{ \left[ 1 - (1 - v)^{1 / b}
\right]^{1 / a} - 1 \right\}^{-1 / \beta} dv
\end{array}}
for \eqn{x > 0}, \eqn{0 < p < 1}, \eqn{\alpha > 0}, the scale parameter, \eqn{\beta > 0}, the first shape parameter,
\eqn{a > 0}, the second shape parameter, and \eqn{b > 0}, the third shape parameter.}
\usage{
dkumloglogis(x, a=1, b=1, alpha=1, beta=1, log=FALSE)
pkumloglogis(x, a=1, b=1, alpha=1, beta=1, log.p=FALSE, lower.tail=TRUE)
varkumloglogis(p, a=1, b=1, alpha=1, beta=1, log.p=FALSE, lower.tail=TRUE)
eskumloglogis(p, a=1, b=1, alpha=1, beta=1)
}
\arguments{
  \item{x}{scaler or vector of values at which the pdf or cdf needs to be computed}
  \item{p}{scaler or vector of values at which the value at risk or expected shortfall needs to be computed}
  \item{alpha}{the value of the scale parameter, must be positive, the default is 1}
  \item{beta}{the value of the first shape parameter, must be positive, the default is 1}
  \item{a}{the value of the second shape parameter, must be positive, the default is 1}
  \item{b}{the value of the third shape parameter, must be positive, the default is 1}
  \item{log}{if TRUE then log(pdf) are returned}
  \item{log.p}{if TRUE then log(cdf) are returned and quantiles are computed for exp(p)}
  \item{lower.tail}{if FALSE then 1-cdf are returned and quantiles are computed for 1-p}
}
\value{An object of the same length as \code{x}, giving the pdf or cdf values computed at \code{x} or an object of the same length as \code{p}, giving the values at risk or expected shortfall computed at \code{p}.}
\references{S. Nadarajah, S. Chan and E. Afuecheta, An R Package for value at risk and expected shortfall, submitted}
\author{Saralees Nadarajah}
\examples{x=runif(10,min=0,max=1)
dkumloglogis(x)
pkumloglogis(x)
varkumloglogis(x)
eskumloglogis(x)}
\keyword{Value at risk, expected shortfall}
