% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/multipleVLGranger.R
\name{multipleVLGrangerFunc}
\alias{multipleVLGrangerFunc}
\title{multipleVLGrangerFunc}
\usage{
multipleVLGrangerFunc(
  TS,
  maxLag,
  alpha = 0.05,
  gamma = 0.3,
  autoLagflag = TRUE,
  causalFlag = 0,
  VLflag = TRUE,
  family = gaussian
)
}
\arguments{
\item{TS}{is a numerical time series of effect where \code{TS[t,k]} is an element at time \code{t} of \code{k}th time series.}

\item{maxLag}{is a maximum possible time delay. The default is 0.2*length(Y).}

\item{alpha}{is a significance level of F-test to determine whether \code{X} Granger-causes \code{Y}.  The default is 0.05.}

\item{gamma}{is a parameter to determine whether \code{X} Granger-causes \code{Y} using BIC difference ratio. The default is  0.3.}

\item{autoLagflag}{is a flag for enabling the automatic lag inference function. The default is true.
If it is set to be true, then maxLag is set automatically using cross-correlation.
Otherwise, if it is set to be false, then the function takes the maxLag value to infer Granger causality.}

\item{causalFlag}{is a choice of criterion for inferring causality:
\code{causalFlag=0} for BIC difference ratio, \code{causalFlag=1} for f-test, or \code{causalFlag=2} for BIC.}

\item{VLflag}{is a flag of Granger causality choice: either \code{VLflag=TRUE} for VL-Granger or \code{VLflag=FALSE} for Granger causality.}

\item{family}{is a parameter of family of function for Generalized Linear Models function (glm). The default is \code{gaussian}.}
}
\value{
This function returns of a list of an adjacency matrix of causality where \code{adjMat[i,j]} is true if \code{TS[,i]} causes \code{TS[,j]}.
}
\description{
multipleVLGrangerFunc is a function that infers Variable-lag Granger Causality of all pairwises of \code{m} time series \code{TS[,1],...TS[,m]}.
}
\examples{
# Generate simulation data
TS <- MultipleSimulationVLtimeseries()
# Run the function
out<-multipleVLGrangerFunc(TS)


}
