% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{NSE}
\alias{NSE}
\alias{RB}
\alias{logNSE}
\alias{rNSE}
\title{Several metrics to evaluate the accuracy of hydrological modeling}
\usage{
NSE(sim, obs)

logNSE(sim, obs)

rNSE(sim, obs)

RB(sim, obs)
}
\arguments{
\item{sim}{Data series to be evaluated, usually are the simulated
streamflow of hydrological model.}

\item{obs}{Data series as benchmark to evaluate \code{sim}, usually
are the observed streamflow.}
}
\value{
The value of NSE, log-NSE, rNSE and RB.
}
\description{
Calculate several metrics for the evaluating of hydrological
modeling accuracy, including the Nash-Sutcliffe coefficient of efficiency
(NSE), Logarithmic NSE (log-NSE), relative NSE (rNSE), and relative bias
(RB).
}
\details{
The Nash-Sutcliffe coefficient of efficiency (NSE) (Nash and Sutcliffe, 1970)
is a widely used indicator of the accuracy of model simulations, or other
estimation method with reference to a benchmark series (usually the
observations), especially the hydrological modeling.

NSE is equal to one minus the normalized mean square error (ratio between
the mean square error and the variation of observations):

\deqn{NSE=1-\sum(sim-obs)**2/\sum(obs-mean(obs))**2}

1 is the perfect value of NSE, and NSE < 0 indicates that the simulation
results are unusable.

The conventional NSE is ususlly affected by the accuracy of high values, and
would impact the low flow simulation when be taken as the objective function
in hydrological model calibration. Therefore, some revised NSE were proposed.

Oudin et al. (2006) proposed the log-NSE to increase the sensitivity to the
accuracy of low flow simulations:

\deqn{log-NSE=1-\sum(log(sim)-log(obs))**2/\sum(log(obs)-log(mean(obs)))**2}

Krause et al. (2005) proposed the relative NSE to reduce the impact of the
magnitude of data:

\deqn{rNSE=1-\sum((sim-obs)obs)**2/\sum((obs-mean(obs))/mean(obs))**2}

Relative bias (RB) is used to quantify the relative systematic bias of the
simulation results:

\deqn{RB=sum(sim)/sum(obs)-1}

Positive or negative value of RB indicate the positive or negative bias of
simulations respectively. Perfect value of RB is 0.
}
\references{
Krause, P., Boyle, D. P., and Base, F., 2005, Comparison of different efficiency
criteria for hydrological model assessment, Advances in Geoscience, 5, 89-97.
doi: 10.5194/adgeo-5-89-2005

Nash, J. E., Sutcliffe, J. V., 1970. River flow forecasting through conceptual
models part I - A discussion of principles. Journal of Hydrology. 10(3): 282-290.
doi:10.1016/0022-1694(70)90255-6

Oudin, L., Andreassian, V., Mathevet, T., Perrin, C., Michel, C., 2006. Dynamic
averaging of rainfall-runoff model simulations from complementary model
parameterizations. Water Resources Research, 42(7). doi: 10.1029/2005WR004636
}
\seealso{
\code{\link{Lohmann_UH}}, \code{\link{Lohmann_conv}}
}

