% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/KernStat.R
\name{KernStat}
\alias{KernStat}
\title{Test statistic calculated from two kernel matrices}
\usage{
KernStat(J, K)
}
\arguments{
\item{J}{\eqn{n \times n} kernel matrix corresponding to first sample.}

\item{K}{\eqn{n \times n} kernel matrix corresponding to second sample.}
}
\value{
Test statistic measure the strength of dependence between the two samples.
}
\description{
Calculate the U-statistic measure of dependence given two kernel matrices \eqn{J}
and \eqn{K}, as described in Section 7.1 of \insertCite{BKS2020}{USP}. For the featured
examples considered these matrices can be calculated using FourierKernel or
InfKern. Alternatively, if a different basis is to be used, then the kernels
can be entered separately.
}
\examples{
x=runif(100); y=runif(100); M=3
J=FourierKernel(x,M); K=FourierKernel(y,M)
KernStat(J,K)
}
\references{
\insertRef{BKS2020}{USP}
}
