% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/COEF.R
\name{coef.UPG.MNL}
\alias{coef.UPG.MNL}
\title{Extract coefficients from UPG.MNL objects}
\usage{
\method{coef}{UPG.MNL}(object, ..., q = c(0.025, 0.975))
}
\arguments{
\item{object}{an object of class \code{UPG.MNL}.}

\item{...}{other coef parameters.}

\item{q}{a numerical vector of length two providing the posterior quantiles to be extracted. Default are 0.025 and 0.975 quantiles.}
}
\value{
Returns a list containing posterior means and the desired credible interval.
}
\description{
\code{coef} can be used to extract posterior means and credible intervals based on posterior quantiles from \code{UPG.MNL} objects.
}
\examples{
\donttest{
# estimate a multinomial logit model using example data
library(UPG)
data(program)
y = program[,1]
X = program[,-1]
results.mnl = UPG(y = y, X = X, model = "mnl")

# extract posterior means and credible interval based on 0.025 and 0.975 quantiles
coef(results.mnl, q = c(0.025, 0.975))
}
}
\seealso{
\code{\link{summary.UPG.MNL}} to summarize a \code{UPG.MNL} object and create tables.
\code{\link{predict.UPG.MNL}} to predict probabilities using a \code{UPG.MNL} object.
\code{\link{plot.UPG.MNL}} to plot a \code{UPG.MNL} object.
}
\author{
Gregor Zens
}
