% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/All.R
\name{PermAdj}
\alias{PermAdj}
\title{Permeable Adjustment}
\usage{
PermAdj(x)
}
\arguments{
\item{x}{The annual maximum sample. Numeric vector}
}
\value{
A dataframe with one row and two columns. Lcv in the first column and Lskew in the second
}
\description{
Adjusts the linear coefficient of variation (Lcv) and the linear skewness to account for non-flood years
}
\details{
The permeable adjustment method is detailed in chapter 19, volume three, of the Flood Estimation Handbook, 1999. The method makes no difference for sites where there are no annual maximums (AM) in the sample that are < median(AM)/2. Once applied the results can be used with the LRatioChange function to update the associated member of a pooling group. Or can be applied directly with the growth factor functions for a single site estimate.
}
\examples{
# Get an anuual maximum sample with a BFIHOST above 0.65 and with some
# annual maximums lower than median(AM)/2. And then apply the function.
AM.39001 <- GetAM(39001)
PermAdj(AM.39001$Flow)
}
\author{
Anthony Hammond
}
