% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/All.R
\name{GenLogAM}
\alias{GenLogAM}
\title{Generalised logistic distribution - estimates directly from sample}
\usage{
GenLogAM(x, RP = 100, q = NULL, trend = FALSE)
}
\arguments{
\item{x}{numeric vector (block maxima sample)}

\item{RP}{return period (default = 100)}

\item{q}{quantile (magnitude of variable)}

\item{trend}{logical argument with default of FALSE. If TRUE, a linear adjustment to the location parameter is made to account for non-stationarity}
}
\value{
quantile as a function of RP or vice versa, with the option of accounting for the linear trend in the sample
}
\description{
Estimated quantiles as a function of return period (RP) and vice versa, directly from the data
}
\details{
If the argument q is used, it overrides RP and provides RP as a function of q (magnitude of variable) as opposed to q as a function of RP. The parameters are estimated by the method of L-moments, as detailed in 'Hosking J. Wallis J. 1997 Regional Frequency Analysis: An Approach Based on L-moments. Cambridge University Press, New York'. The trend argument allows the location parameter to move in line with the observed linear trend of the sample. Another option is to detrend the sample first with the DeLinTrend function. On average this makes little difference to the two year flow but lower results for longer return periods (not always) when compared to the trend option in this function.
}
\examples{
#Get an annual maximum sample and estimate the 50-year RP
AM.27090 <- GetAM(27090)
GenLogAM(AM.27090$Flow, RP = 50)
#Estimate the RP for a 600m3/s discharge
GenLogAM(AM.27090$Flow, q = 600)
#Estimate the 50-year RP allowing for non-stationarity in the location parameter
GenLogAM(AM.27090$Flow, RP = 50, trend = TRUE)
}
\author{
Anthony Hammond
}
