% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/All.R
\name{DeLinTrend}
\alias{DeLinTrend}
\title{Linearly detrend a sample}
\usage{
DeLinTrend(x)
}
\arguments{
\item{x}{a numeric vector}
}
\value{
A numeric vector which is a linearly detrended version of x.
}
\description{
Applies a linear detrend to a sample
}
\details{
Adjusts all the values in the sample, of size n, by the difference between the linearly modelled ith data point and the linearly modelled nth data point.
}
\examples{
# Get an annual maximum (AM) sample that looks to have a significant trend
AM.21025 <- GetAM(21025)
# plot the resulting AM as a bar plot. Then detrend and compare with another plot
plot(AM.21025$Flow, type = "h", ylab = "Discharge (m3/s)")
AM.Detrend <- DeLinTrend(AM.21025$Flow)
plot(AM.Detrend, type = "h", ylab = "Discharge (m3/s)")
}
\author{
Anthony Hammond
}
