% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/vis_pancan_value.R
\name{vis_toil_gene}
\alias{vis_toil_gene}
\title{Visualize single gene expression from toil data hub}
\usage{
vis_toil_gene(
  data,
  x = "primary_site",
  y = "expression",
  color = "sample_type",
  palette = "jco",
  xlab = "Primary site",
  ylab = "Expression",
  title = NULL,
  facet.by = NULL,
  angle.x = 45,
  ...
)
}
\arguments{
\item{data}{a data frame}

\item{x}{character string containing the name of x variable.}

\item{y}{character vector containing one or more variables to plot}

\item{color}{outline color.}

\item{palette}{the color palette to be used for coloring or filling by groups.
Allowed values include "grey" for grey color palettes; brewer palettes e.g.
"RdBu", "Blues", ...; or custom color palette e.g. c("blue", "red"); and
scientific journal palettes from ggsci R package, e.g.: "npg", "aaas",
"lancet", "jco", "ucscgb", "uchicago", "simpsons" and "rickandmorty".}

\item{xlab}{character vector specifying x axis labels. Use xlab = FALSE to
hide xlab.}

\item{ylab}{character vector specifying y axis labels. Use ylab = FALSE to
hide ylab.}

\item{title}{plot main title.}

\item{facet.by}{character vector, of length 1 or 2, specifying grouping
variables for faceting the plot into multiple panels. Should be in the data.}

\item{angle.x}{angle for x lab}

\item{...}{other parameters passing to \code{\link[ggpubr:ggboxplot]{ggpubr::ggboxplot()}}}
}
\value{
a \code{ggplot} object
}
\description{
Visualize single gene expression from toil data hub
}
