% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/startingPoint2tanchor.R
\name{startingPoint2tanchor}
\alias{startingPoint2tanchor}
\title{Convert FiSAT's starting point to t_anchor value}
\usage{
startingPoint2tanchor(param, par, startingLength, startingSample)
}
\arguments{
\item{param}{list with dates, midLengths, and catch}

\item{par}{list with growth parameters 'Linf' and 'K' of VBGF}

\item{startingLength}{starting length as returned by FiSAT, indicating the length within
the starting sample cut by a growth curve}

\item{startingSample}{starting sample as returned by FiSAT, indicating the sample which is
cut by a growth curve}
}
\value{
list with input elements and estimated t_anchor value
}
\description{
Starting points returned or chosen within FiSAT are not supported
   in TropFishR. Instead \code{t_anchor} takes on the job of anchoring VBGF growth curves on
   a temporal axis. This function allows to convert FiSAT's starting points to \code{t_anchor} values
}
\examples{
data(synLFQ5)
lfqNEW <- startingPoint2tanchor(synLFQ5, par = list(Linf = 92, K = 0.37),
   startingLength = 31, startingSample = 4)
lfqRest <- lfqRestructure(lfqNEW, MA = 11)
plot(lfqRest,par=list(Linf=lfqRest$Linf,K=lfqRest$K,t_anchor=lfqRest$t_anchor))

}
\keyword{function}
\keyword{lfq}
\keyword{startingPoints}
\keyword{t_anchor}

