% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/prod_mod_ts.R
\name{prod_mod_ts}
\alias{prod_mod_ts}
\title{Production models with time series fitting}
\usage{
prod_mod_ts(data, method = "Schaefer", B0_init = NA, B0_est = NA,
  effort_unit = 1, plot = TRUE)
}
\arguments{
\item{data}{a dataframe of parameters
\itemize{
  \item \code{year} years,
  \item \code{yield} catch in weight of fishery per year,
  \item \code{effort} fishing effort per year,
  \item \code{CPUE} catch per unit of effort per year (optional).
}}

\item{method}{indicating if Schaefer or Fox model should be applied. First assumes a
logistic relationship between growth rate and biomass, whereas second assumes it to
foolow the Gompertz distribution (Richards 1959). Default is the dynamic Schaefer model.}

\item{B0_init}{numeric; if realistic initial estimate for virgin biomass is available.
If NA initial estimate for virgin biomass is set to two times average yield of all
or part of yield values (see \code{B0_est}).}

\item{B0_est}{intital value of virgin biomass estimating using all yield values (NA) or
first years of time series, then provide numerical representing number of years}

\item{effort_unit}{multiplication factor for the unit of effort. Default is 1.}

\item{plot}{logical; if TRUE (default) a graph is displayed}
}
\value{
A list with the input parameters and following list objects:
\itemize{
  \item \strong{Bvec}: biomass vector,
  \item \strong{CPUE_hat}: predicted CPUE,
  \item \strong{K}: carrying capacity,
  \item \strong{r}: population growth rate,
  \item \strong{q}: catchability coefficient,
  \item \strong{MSY}: maximum sustainabale yield (MSY),
  \item \strong{Bmsy}: biomass at MSY,
  \item \strong{Emsy}: fishing effort at MSY
  \item \strong{Fmsy}: fishing mortality at MSY,
}
}
\description{
This function applies the production models under non-equilibrium
     conditions by applying time series fitting using non-linear least squares
     minimisation.
}
\details{
Either catch per unit of effort (CPUE) is inserted
   into the model directly (by a column \code{CPUE}) or CPUE is calculated from
   the catch and effort, then these two vectors should have required units.
   Whenever a good estimate for the virigin biomass is available, this estimate
   should be inserted for \code{B_init}. The default approach for the initial
   estimate of the virgin biomass is to multiply the average yield by 2 (Dharmendra
   and Solmundsson, 2005). Alternatively, just a part of the time series of
   yield values can be choosen to represent the virgin biomass.
   The minimisation procedure is based on least error sum of squares (SSE). For
   the logistic (Schaefer) method the standard calculation of SSE is applied
   (\code{sum((CPUE - predicted CPUE)^2)}), for
   the method with Gompertz distribution (Fox) SSE is calculated according to
   the Thiel's U statistic \code{sqrt(sum(CPUE - predicted CPUE)/sum(CPUE(t) - CPUE(t-1)))}
   (Wittink, 1988).
}
\examples{
data(emperor)
prod_mod_ts(emperor, method = "Schaefer")
prod_mod_ts(emperor, method = "Fox")


}
\references{
Dharmendra, D., Solmundsson, J., 2005. Stock assessment of the offshore Mauritian banks
using dynamic biomass models and analysis of length frequency of the Sky Emperor
(\emph{Lethrinus mahsena}). Fisheries Training Program The United Nations University, 61

Hilborn, R. and Walters, C., 1992. Quantitative Fisheries Stock Assessment: Choice,
Dynamics and Uncertainty. Chapman and Hall, New York

Prager, M. H., 1994. A suite of extensions to a non-equilibrium surplus production
model. \emph{Fishery Bulletin} 92: 374-389

Richards, F. J., 1959. A flexible growth function for empirical use.
\emph{Journal of experimental Botany}, 10(2), 290-301.

Wittink, D. R., 1988. The application of regression analysis. Allyn and Bacon. Inc.
Boston. MA. 324p.
}
\keyword{MSY}
\keyword{biomass}
\keyword{function}
\keyword{production}

