% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/predict.R
\name{predict.TE_msm}
\alias{predict.TE_msm}
\title{Predict Cumulative Incidence with Confidence Intervals}
\usage{
\method{predict}{TE_msm}(
  object,
  newdata,
  predict_times,
  conf_int = TRUE,
  samples = 100,
  type = c("cum_inc", "survival"),
  ...
)
}
\arguments{
\item{object}{Object from \code{\link[=trial_msm]{trial_msm()}} or \code{\link[=initiators]{initiators()}}.}

\item{newdata}{Baseline trial data to predict cumulative incidence or survival for. If \code{newdata} contains
rows with \code{followup_time > 0} these will be removed.}

\item{predict_times}{Follow-up times to predict. Any times given in newdata will be ignored.}

\item{conf_int}{Calculate a confidence interval using coefficient samples from a multivariate normal distribution
based on the robust covariance matrix.}

\item{samples}{The number of samples of the coefficients for prediction models.}

\item{type}{Type of values to calculate. Either cumulative incidence (\code{"cum_inc"}) or survival (\code{"survival"}).}

\item{...}{Further arguments passed to or from other methods.}
}
\value{
A list of three data frames containing the cumulative incidences for each of the assigned treatment options
and the difference between them.
}
\description{
Predict Cumulative Incidence with Confidence Intervals
}
\examples{
# If necessary set the number of `data.table` threads
data.table::setDTthreads(2)

data("te_model_ex")
predicted_ci <- predict(te_model_ex, predict_times = 0:30, samples = 10)

# Plot the cumulative incidence curves for each treatment
plot(predicted_ci[[1]]$followup_time, predicted_ci[[1]]$cum_inc,
  type = "l",
  xlab = "Follow-up Time", ylab = "Cumulative Incidence"
)
lines(predicted_ci[[1]]$followup_time, predicted_ci[[1]]$`2.5\%`, lty = 2)
lines(predicted_ci[[1]]$followup_time, predicted_ci[[1]]$`97.5\%`, lty = 2)

lines(predicted_ci[[2]]$followup_time, predicted_ci[[2]]$cum_inc, type = "l", col = 2)
lines(predicted_ci[[2]]$followup_time, predicted_ci[[2]]$`2.5\%`, lty = 2, col = 2)
lines(predicted_ci[[2]]$followup_time, predicted_ci[[2]]$`97.5\%`, lty = 2, col = 2)
legend("topleft", title = "Assigned Treatment", legend = c("0", "1"), col = 1:2, lty = 1)

# Plot the difference in cumulative incidence over follow up
plot(predicted_ci[[3]]$followup_time, predicted_ci[[3]]$cum_inc_diff,
  type = "l",
  xlab = "Follow-up Time", ylab = "Difference in Cumulative Incidence",
  ylim = c(-0.1, 0.1)
)
lines(predicted_ci[[3]]$followup_time, predicted_ci[[3]]$`2.5\%`, lty = 2)
lines(predicted_ci[[3]]$followup_time, predicted_ci[[3]]$`97.5\%`, lty = 2)

}
