% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/TsoilFunctions.R
\name{soil_temperature}
\alias{soil_temperature}
\title{Calculate Soil Temperature using ODEs}
\usage{
soil_temperature(
  z_r.intervals = 12,
  z_r,
  z,
  T_a,
  u,
  Tsoil0,
  z0,
  SSA,
  TimeIn,
  H,
  water_content = 0.2,
  air_pressure,
  rho_so = 1620,
  shade = FALSE
)
}
\arguments{
\item{z_r.intervals}{\code{numeric} the number of intervals in the soil profile to calculate, defaults to 12.}

\item{z_r}{\code{numeric} reference height (m).}

\item{z}{\code{numeric} interval of the soil profile to return (1 to \code{z_r.intervals}).}

\item{T_a}{\code{numeric} vector of air temperature (degrees C), Note: missing values will be linearly interpolated.}

\item{u}{\code{numeric} vector of wind speeds (\ifelse{html}{\out{m s<sup>-1</sup>}}{\eqn{m s^-1}{ASCII}}).}

\item{Tsoil0}{\code{numeric} initial soil temperature (degrees C).}

\item{z0}{\code{numeric} surface roughness (m).}

\item{SSA}{\code{numeric} solar absorptivity of soil surface as a fraction.}

\item{TimeIn}{\code{numeric} vector of time periods for the model.}

\item{H}{\code{numeric} vector of solar radiation (\ifelse{html}{\out{W m<sup>-2</sup>}}{\eqn{W m^-2}{ASCII}}).}

\item{water_content}{\code{numeric} percent water content (percent).}

\item{air_pressure}{\code{numeric} air pressure (kPa).}

\item{rho_so}{\code{numeric} particle density of soil.}

\item{shade}{\code{logical} whether or not soil temperature should be calculated in the shade.}
}
\value{
\code{numeric} soil temperature (C).
}
\description{
This function is called to calculate soil temperature (C) as in \insertCite{Beckman1973;textual}{TrenchR}. This function calls \code{\link{soil_temperature_function}}, which uses ODEs to calculate a soil profile using equations from \insertCite{deVries1963;textual}{TrenchR}
}
\examples{
  set.seed(123)
  temp_vector       <- runif(48, min = -10, max = 10)
  wind_speed_vector <- runif(48, min = 0, max = 0.4)
  time_vector       <- rep(1:24, 2)
  solrad_vector     <- rep(c(rep(0, 6), 
                             seq(10, 700, length.out = 6), 
                             seq(700, 10, length.out = 6), 
                             rep(0, 6)),
                           2)

  soil_temperature(z_r.intervals = 12, 
                   z_r           = 1.5, 
                   z             = 2, 
                   T_a           = temp_vector, 
                   u             = wind_speed_vector, 
                   Tsoil0        = 20, 
                   z0            = 0.02, 
                   SSA           = 0.7, 
                   TimeIn        = time_vector, 
                   H             = solrad_vector, 
                   water_content = 0.2, 
                   air_pressure  = 85, 
                   rho_so        = 1620, 
                   shade         = FALSE)

}
\references{
\insertAllCited{}
}
\seealso{
Other soil temperature functions: 
\code{\link{soil_conductivity}()},
\code{\link{soil_specific_heat}()},
\code{\link{soil_temperature_equation}()},
\code{\link{soil_temperature_function}()},
\code{\link{soil_temperature_integrand}()}
}
\author{
Joseph Grigg
}
\concept{soil temperature functions}
