% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllometricFunctions.R
\name{proportion_silhouette_area}
\alias{proportion_silhouette_area}
\title{Organism Silhouette Area}
\usage{
proportion_silhouette_area(z, taxon, raz = 0, posture = "prostrate")
}
\arguments{
\item{z}{\code{numeric} zenith angle in degrees between \code{0} and \code{360}.}

\item{taxon}{\code{character} organism name. Current choices are \code{"lizard"}, \code{"frog"}, and \code{"grasshopper"}.}

\item{raz}{\code{numeric} relative solar azimuth angle (in degrees). Required if \code{taxon = "lizard"}. This is the horizontal angle of the sun relative to the head and frontal plane of the lizard and options currently include \code{0} (in front), \code{90} (to side), and \code{180} (behind) degrees.}

\item{posture}{\code{character} value describing posture. Required if \code{taxon = "lizard"}. Options include \code{"prostrate"} (default) and \code{"elevated"}.}
}
\value{
\code{numeric} silhouette area as a proportion.
}
\description{
The function estimates the projected (silhouette) area as a portion of the surface area of the organism as a function of zenith angle. The function is useful for estimating absorbed solar radiation.
}
\details{
Relationships come from \itemize{
  \item Lizards: \insertCite{Muth1977;textual}{TrenchR}
  \item Frogs: \insertCite{Tracy1976;textual}{TrenchR}
  \item Grasshoppers: \insertCite{Anderson1979;textual}{TrenchR}
 }
}
\examples{
  proportion_silhouette_area(z     = 60,   
                             taxon = "frog")
  proportion_silhouette_area(z     = 60, 
                             taxon = "grasshopper")
  proportion_silhouette_area(z       = 60, 
                             taxon   = "lizard", 
                             posture = "prostrate", 
                             raz     = 90)
  proportion_silhouette_area(z       = 60, 
                             taxon   = "lizard", 
                             posture = "elevated", 
                             raz     = 180)

}
\references{
\insertAllCited{}
}
\seealso{
Other allometric functions: 
\code{\link{mass_from_length}()},
\code{\link{proportion_silhouette_area_shapes}()},
\code{\link{surface_area_from_length}()},
\code{\link{surface_area_from_mass}()},
\code{\link{surface_area_from_volume}()},
\code{\link{volume_from_length}()}
}
\concept{allometric functions}
