% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllometricFunctions.R
\name{surface_area_from_volume}
\alias{surface_area_from_volume}
\title{Organism Surface Area from Volume}
\usage{
surface_area_from_volume(V, taxon)
}
\arguments{
\item{V}{\code{numeric} vector of volume (\ifelse{html}{\out{m<sup>3</sup>}}{\eqn{m^3}{ASCII}}). Can be one or more values.}

\item{taxon}{\code{character} taxon of organism, current choices: \code{"lizard"}, \code{"frog"}, \code{"sphere"}.}
}
\value{
\code{numeric} surface area (\ifelse{html}{\out{m<sup>2</sup>}}{\eqn{m^2}{ASCII}}).
}
\description{
The function estimates surface area (\ifelse{html}{\out{m<sup>2</sup>}}{\eqn{m^2}{ASCII}}) from volume (\ifelse{html}{\out{m<sup>3</sup>}}{\eqn{m^3}{ASCII}}) for a variety of taxa following \insertCite{Mitchell1976;textual}{TrenchR}.
}
\details{
All models follow (\ifelse{html}{\out{SA = Ka V<sup>2/3</sup>}}{\eqn{SA = Ka * V^{2/3}}{ASCII}}) with surface area and volume in meters.
 \itemize{
  \item Lizards: \insertCite{Norris1965;textual}{TrenchR}:
    \cr 
    \cr \eqn{Ka = 11.0} 
  \item Frogs: \insertCite{Tracy1972;textual}{TrenchR}:
    \cr 
    \cr \eqn{Ka = 11.0} 
  \item Sphere: \insertCite{Mitchell1976;textual}{TrenchR}:
    \cr 
    \cr \eqn{Ka = 4.83} 
 }
}
\examples{
  surface_area_from_volume(V     = 0.001, 
                           taxon = "lizard")
  surface_area_from_volume(V     = 0.001,  
                           taxon = "frog")
  surface_area_from_volume(V     = 0.001,  
                           taxon = "sphere")

}
\references{
\insertAllCited{}
}
\seealso{
Other allometric functions: 
\code{\link{mass_from_length}()},
\code{\link{proportion_silhouette_area_shapes}()},
\code{\link{proportion_silhouette_area}()},
\code{\link{surface_area_from_length}()},
\code{\link{surface_area_from_mass}()},
\code{\link{volume_from_length}()}
}
\concept{allometric functions}
