% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Combinatorics.R
\name{DoubleFactorial}
\alias{DoubleFactorial}
\alias{DoubleFactorial64}
\alias{LnDoubleFactorial}
\alias{Log2DoubleFactorial}
\alias{LogDoubleFactorial}
\alias{LnDoubleFactorial.int}
\alias{LogDoubleFactorial.int}
\title{Double factorial}
\usage{
DoubleFactorial(n)

DoubleFactorial64(n)

LnDoubleFactorial(n)

Log2DoubleFactorial(n)

LogDoubleFactorial(n)

LnDoubleFactorial.int(n)

LogDoubleFactorial.int(n)
}
\arguments{
\item{n}{Vector of integers.}
}
\value{
Returns the double factorial, \emph{n} * (\emph{n} - 2) * (\emph{n} - 4) *
(\emph{n} - 6) * ...
}
\description{
Calculate the double factorial of a number, or its logarithm.
}
\section{Functions}{
\itemize{
\item \code{DoubleFactorial64()}: Returns the exact double factorial as a 64-bit
\code{integer64}, for \code{n} < 34.

\item \code{LnDoubleFactorial()}: Returns the logarithm of the double factorial.

\item \code{Log2DoubleFactorial()}: Returns the logarithm of the double factorial.

\item \code{LnDoubleFactorial.int()}: Slightly faster, when x is known to be length one
and below 50001

}}
\examples{
DoubleFactorial (-4:0) # Return 1 if n < 2
DoubleFactorial (2) # 2
DoubleFactorial (5) # 1 * 3 * 5
exp(LnDoubleFactorial.int (8)) # log(2 * 4 * 6 * 8)
DoubleFactorial64(31)
}
\seealso{
Other double factorials: 
\code{\link{doubleFactorials}},
\code{\link{logDoubleFactorials}}
}
\author{
Martin R. Smith (\href{mailto:martin.smith@durham.ac.uk}{martin.smith@durham.ac.uk})
}
\concept{double factorials}
