% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/KeptVerts.R
\name{KeptVerts}
\alias{KeptVerts}
\alias{KeptVerts.phylo}
\alias{KeptVerts.numeric}
\title{Identify vertices retained when leaves are dropped}
\usage{
KeptVerts(tree, keptTips, tipLabels = TipLabels(tree))

\method{KeptVerts}{phylo}(tree, keptTips, tipLabels = TipLabels(tree))

\method{KeptVerts}{numeric}(tree, keptTips, tipLabels = TipLabels(tree))
}
\arguments{
\item{tree}{Original tree of class \code{phylo}, in \code{\link{Preorder}}.}

\item{keptTips}{Either:
\itemize{
\item a logical vector stating whether each leaf should be retained, in a
sequence corresponding to \code{tree[["tip.label"]]}; or
\item a character vector listing the leaf labels to retain; or
\item a numeric vector listing the indices of leaves to retain.
}}

\item{tipLabels}{Optional character vector naming the leaves of \code{tree},
if \code{keptTips} is not logical.  Inferred from \code{tree} if unspecified.}
}
\description{
Identify vertices retained when leaves are dropped
}
\examples{
master <- BalancedTree(12)
master <- Preorder(master) # Nodes must be listed in Preorder sequence
plot(master)
nodelabels()

allTips <- master[["tip.label"]]
keptTips <- sample(allTips, 8)
plot(KeepTip(master, keptTips))
kept <- KeptVerts(master, allTips \%in\% keptTips)

map <- which(kept)
# Node `i` in the reduced tree corresponds to node `map[i]` in the original.
}
\seealso{
Other tree manipulation: 
\code{\link{AddTip}()},
\code{\link{CollapseNode}()},
\code{\link{ConsensusWithout}()},
\code{\link{DropTip}()},
\code{\link{EnforceOutgroup}()},
\code{\link{ImposeConstraint}()},
\code{\link{KeptPaths}()},
\code{\link{LeafLabelInterchange}()},
\code{\link{MakeTreeBinary}()},
\code{\link{RenumberTips}()},
\code{\link{RenumberTree}()},
\code{\link{Renumber}()},
\code{\link{RootTree}()},
\code{\link{SingleTaxonTree}()},
\code{\link{SortTree}()},
\code{\link{Subtree}()}
}
\author{
Martin R. Smith (\href{mailto:martin.smith@durham.ac.uk}{martin.smith@durham.ac.uk})
}
\concept{tree manipulation}
