% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mst.R
\name{MSTEdges}
\alias{MSTEdges}
\title{Edges of minimum spanning tree}
\usage{
MSTEdges(distances, plot = FALSE, x = NULL, y = NULL, ...)
}
\arguments{
\item{distances}{Either a matrix that can be interpreted as a distance
matrix, or an object of class \code{dist}.}

\item{plot}{Logical specifying whether to add the minimum spanning tree
to an existing plot.}

\item{x, y}{Numeric vectors specifying the X and Y coordinates of each
element in \code{distances}.  Necessary only if \code{plot = TRUE}.}

\item{\dots}{Additional parameters to send to \verb{[lines()]}.}
}
\value{
\code{MSTEdges()} returns a matrix in which each row corresponds to an
edge of the minimum spanning tree, and each column lists the index of the
entry in \code{distances} at which the line begins and ends.
}
\description{
Calculate or plot the ends of each edge of the minimum spanning tree of a
distance matrix.
}
\examples{
# Corners of an almost-regular octahedron
points <- matrix(c(0, 0, 2, 2, 1.1, 1,
                   0, 2, 0, 2, 1, 1.1,
                   0, 0, 0, 0, 1, -1), 6)
distances <- dist(points)
MSTEdges(distances)
plot(points[, 1:2], ann = FALSE, asp = 1)
MSTEdges(distances, TRUE, x = points[, 1], y = points[, 2], lwd = 2)
}
\references{
\insertRef{Gower1969}{TreeTools}
}
\seealso{
Calculate minimum spanning tree: \code{\link[ape:mst]{ape::mst()}}.
}
\author{
Martin R. Smith (\href{mailto:martin.smith@durham.ac.uk}{martin.smith@durham.ac.uk})
}
