% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tree_generation.R
\name{RandomTree}
\alias{RandomTree}
\title{Generate a random tree topology}
\usage{
RandomTree(tips, root = FALSE)
}
\arguments{
\item{tips}{An integer specifying the number of tips, or a character vector
naming the tips, or any other object from which tip labels can be extracted
with function \code{TipLabels}.}

\item{root}{Tip to use as root (if desired; FALSE otherwise)}
}
\value{
\code{RandomTree} returns a random tree of class \code{phylo}, with the
specified tips, and no branch lengths specified.
}
\description{
Generates a binary tree with a random topology on specified tips, optionally
rooting the tree on a given tip.
}
\examples{
RandomTree(letters[1:5])

data('Lobo')
RandomTree(Lobo.phy)

}
\seealso{
Other tree generation functions: 
\code{\link{BalancedTree}()},
\code{\link{NJTree}()},
\code{\link{PectinateTree}()},
\code{\link{SingleTaxonTree}()},
\code{\link{TreeNumber}}
}
\author{
Martin R. Smith (\href{mailto:martin.smith@durham.ac.uk}{martin.smith@durham.ac.uk})
}
\concept{tree generation functions}
