% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/phylo.R
\name{SingleTaxonTree}
\alias{SingleTaxonTree}
\title{SingleTaxonTree}
\usage{
SingleTaxonTree(label)
}
\arguments{
\item{label}{a character vector specifying the label of the tip.}
}
\value{
\code{SingleTaxonTree} returns a \code{phylo} object containing a single
tip with the specified label.
}
\description{
Single taxon tree
}
\details{
Create a phylogenetic 'tree' that comprises a single taxon.
}
\examples{
SingleTaxonTree('Homo_sapiens')
plot(SingleTaxonTree('root') + BalancedTree(4))

}
\seealso{
Other tree manipulation: \code{\link{AddTip}},
  \code{\link{Renumber}}, \code{\link{Subtree}}

Other tree generation functions: \code{\link{BalancedTree}},
  \code{\link{NJTree}}, \code{\link{PectinateTree}},
  \code{\link{RandomTree}}, \code{\link{TreeNumber}}
}
\concept{tree generation functions}
\concept{tree manipulation}
\keyword{tree}
