% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Combinatorics.R
\name{DoubleFactorial}
\alias{DoubleFactorial}
\alias{LogDoubleFactorial}
\alias{LogDoubleFactorial.int}
\title{Double Factorial}
\usage{
DoubleFactorial(n)

LogDoubleFactorial(n)

LogDoubleFactorial.int(n)
}
\arguments{
\item{n}{Vector of integers.}
}
\value{
Returns the double factorial, n x (n - 2) x (n - 4) x (n - 6) x ...
}
\description{
Double Factorial
}
\section{Functions}{
\itemize{
\item \code{LogDoubleFactorial}: Returns the logarithm of the double factorial.

\item \code{LogDoubleFactorial.int}: Slightly faster, when x is known to be length one
and below 50001
}}

\examples{
{
DoubleFactorial (-4:0) # Return 1 if n < 2
DoubleFactorial (2) # 2
DoubleFactorial (5) # 1 x 3 x 5
exp(LogDoubleFactorial.int (8)) # 2 x 4 x 6 x 8

}

}
\seealso{
Other Double factorial: \code{\link{doubleFactorials}},
  \code{\link{logDoubleFactorials}}
}
\author{
Martin R. Smith (\href{mailto:martin.smith@durham.ac.uk}{martin.smith@durham.ac.uk})
}
\concept{Double factorial}
