% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Splits.R
\name{in.Splits}
\alias{in.Splits}
\title{Splits in Splits object}
\usage{
in.Splits(x, table, incomparables = NULL)
}
\arguments{
\item{x, table}{Object of class \code{Splits}.}

\item{incomparables}{A vector of values that cannot be matched. Any value in
\code{x} matching a value in this vector is assigned the \code{nomatch} value.
For historical reasons, \code{FALSE} is equivalent to \code{NULL}.}
}
\value{
A logical vector specifying which of the splits in \code{x} are present
in \code{table}.
}
\description{
\code{in.Splits} is an equivalent to \code{\%in\%} that can be applied to objects
of class \code{Splits}.
}
\examples{
splits1 <- as.Splits(BalancedTree(7))
splits2 <- as.Splits(PectinateTree(7))

in.Splits(splits1, splits2)

}
\seealso{
Other Splits operations: \code{\link{NSplits}},
  \code{\link{NTip}}, \code{\link{TipLabels}},
  \code{\link{TipsInSplits}}, \code{\link{as.Splits}},
  \code{\link{match.Splits}}
}
\author{
Martin R. Smith (\href{mailto:martin.smith@durham.ac.uk}{martin.smith@durham.ac.uk})
}
\concept{Splits operations}
