% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fatorial2.ad.dic.R
\name{fatorial2.ad.dic}
\alias{fatorial2.ad.dic}
\title{Analise de experimento em esquema fatorial duplo com testemunhas em DIC}
\usage{
fatorial2.ad.dic(Dados,Protegido=FALSE,alfa=0.05,quali=c(TRUE,TRUE),verbose=TRUE,plot=2)
}
\arguments{
\item{Dados}{Matriz contendo na primeira coluna a identificacao das
testemunhas (tratamentos comuns deve ter valor "NA" ou zero). A segunda
coluna deve ter a identificacao dos niveis do primeiro fator. A terceira
coluna a identificacao dos niveis do segundo fator. A quarta coluna a
identificacao das repeticoes. Na quinta coluna os resultados experimentais.}

\item{Protegido}{Valor logico. Se for FALSE os testes de medias serao feitos
indendente das significancias pelo teste F. Se for TRUE os testes de medias
serao feitas apenas quando haver efeito significativo pelo teste F.}

\item{alfa}{Valor indicando o nivel de significancia deve ser obrigatoriamente
"0.001", "0.01", "0.05" ou "0.10" (default = 0.05).}

\item{quali}{Vetor com dois valores logicos (TRUE/FALSE). TRUE indica que o
respectivo fator e qualitativo, realizando-se o teste de medias. FALSE
indica que o fator e quantitativo, sendo feita a analise de regressao.}

\item{verbose}{Valor logico (TRUE/FALSE). TRUE apresenta os resultados da analise.}

\item{plot}{Valor numerico indicando o grafico desejado para analise dos residuos:
\itemize{
 \item 1: Residuals vs Fitted
\item 2:  QQ-plot
 \item 3:  Scale-Location
  \item 4:  Cook's distance
   \item 5: Histogram
   }}
}
\value{
Retorna a comparacao multipla de medias obtida por varios testes para
 tratamentos qualitativos e regressao para testes quantitativos. O teste
 Dunnet e feito para comparar os tratamentos testemunhas com os demais.
}
\description{
Esta funcao considera experimentos em esquema fatorial no
 delineamento inteiramente casualizado.Esta funcao retorna a comparacao
 multipla de medias (obtidas pelos testes t, t com protecao de Bonferroni,
 Duncan, Dunnet, SNK, Tukey e Scott-Knott) se o fator for qualitativo. Ou a
 analise de regressao se o fator for quantitativo. Para comparar a testemunha
 adicional com os demais e utilizado o teste Dunnet.  "This function
 considers experiments in factorial scheme for the completely randomized
 design. This function returns the multiple comparison tests ( t, t with
 Bonferroni protection, Duncan, Dunnet, SNK, Tukey and Scott-Knott) if the
 factor is qualitative. Or regression analysis if the factor is quantitative.
 To compare the additionals controls with the others treatments, the Dunnet
 test is used."
}
\examples{
##Exemplo de experimento com duas testemunhas adicionais e fatores qualitativos

data(Dados3)
fatorial2.ad.dic(Dados3,Protegido=FALSE,alfa = 0.05,quali = c(TRUE,TRUE))

##Exemplo de experimento com uma testemunha adicional e um fator qualitativo
data(Dados4)
fatorial2.ad.dic(Dados4,Protegido=TRUE,alfa = 0.05,quali = c(FALSE,TRUE))

##Exemplo com tres testemunhas adicionais e um fator qualitativo
data(Dados5)
fatorial2.ad.dic(Dados5,Protegido=TRUE,alfa = 0.05,quali = c(TRUE,FALSE))
}
\references{
Canal no youtube -> Alcinei Azevedo - Dicas e aulas
<https://www.youtube.com/playlist?list=PLvth1ZcREyK4wSzwg-IxvrzaNzSLLrXEB>

 BANZATTO, D. A.; KRONKA, S. N. Experimentacao Agricola. 4 ed.
 Jaboticabal: Funep. 2006. 237 p.

 GOMES, F. P. Curso de Estatistica Experimental. 10a ed. Piracicaba:
 ESALQ/USP. 1982. 430.
}
\author{
Alcinei Mistico Azevedo, \email{alcineimistico@hotmail.com}
}
