% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/additionalFunctions.R
\name{fun_from_folder}
\alias{fun_from_folder}
\title{Apply function within a folder}
\usage{
fun_from_folder(folder, fun, ...)
}
\arguments{
\item{folder}{The folder of execution that the function is switched to before executing \code{fun}}

\item{fun}{Function to be executed from the relative path}

\item{...}{Options to be passed to \code{fun}}
}
\value{
The return value of \code{fun(...)}
}
\description{
It executes the function \code{fun} by first switching directories temporarily to the folder \code{folder} and then returning to the working directory.
}
\examples{
list.files()
fun_from_folder(system.file("data", package = "TexExamRandomizer"), list.files)
list.files()
}
