% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/item_pool_operators.R
\docType{methods}
\name{item_pool-operators}
\alias{item_pool-operators}
\alias{subsetItemPool}
\alias{combineItemPool}
\alias{[,item_pool,numeric-method}
\alias{[,item_pool,numeric,ANY,ANY-method}
\alias{c,item_pool-method}
\alias{+.item_pool}
\alias{-.item_pool}
\alias{==.item_pool}
\title{Basic operators for item pool objects}
\usage{
subsetItemPool(x, i = NULL)

combineItemPool(x1, x2, unique = TRUE, verbose = TRUE)

\S4method{[}{item_pool,numeric}(x, i, j, ..., drop = TRUE)

\S4method{c}{item_pool}(x, ...)

\method{+}{item_pool}(x1, x2)

\method{-}{item_pool}(x1, x2)

\method{==}{item_pool}(x1, x2)
}
\arguments{
\item{x, x1, x2}{an \code{\linkS4class{item_pool}} object.}

\item{i}{item indices to use in subsetting.}

\item{unique}{if \code{TRUE}, remove items with duplicate IDs after combining. (default = \code{TRUE})}

\item{verbose}{if \code{TRUE}, raise a warning if duplicate IDs are found after combining. (default = \code{TRUE})}

\item{j, drop, ...}{not used, exists for compatibility.}
}
\description{
Create a subset of an \code{\linkS4class{item_pool}} object:

\itemize{
  \item{\code{pool[i]}}
  \item{\code{subsetItemPool(pool, i)}}
}

Combine two \code{\linkS4class{item_pool}} objects:

\itemize{
  \item{\code{c(pool1, pool2)}}
  \item{\code{combineItemPool(pool1, pool2)}}
  \item{\code{pool1 + pool2}}
}

\code{pool1 - pool2} excludes items in \code{pool2} from \code{pool1}.

\code{pool1 == pool2} tests whether two \code{\linkS4class{item_pool}} objects are identical.
}
\examples{
p1 <- itempool_science[1:100]
p2 <- c(itempool_science, itempool_reading)
p3 <- p2 - p1

p1 <- itempool_science[1:500]
p2 <- itempool_science - p1
p3 <- itempool_science[501:1000]
identical(p2, p3)  ## TRUE

p <- p1 + p3
p == itempool_science ## TRUE

}
