% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/datasets.R
\docType{data}
\name{dataset_reading}
\alias{dataset_reading}
\alias{itempool_reading_data}
\alias{itemattrib_reading_data}
\alias{stimattrib_reading_data}
\alias{constraints_reading_data}
\alias{itempool_reading}
\alias{itemattrib_reading}
\alias{stimattrib_reading}
\alias{constraints_reading}
\title{Reading dataset}
\description{
Stimulus-based example item pool (303 items).
}
\details{
This pool is associated with the following objects:
\itemize{
  \item \code{itempool_reading} An \code{\linkS4class{item_pool}} object.
  \item \code{itemattrib_reading} An \code{\linkS4class{item_attrib}} object containing item attributes.
  \item \code{stimattrib_reading} A \code{\linkS4class{st_attrib}} object containing stimulus attributes.
  \item \code{constraints_reading} A \code{\linkS4class{constraints}} object containing 18 constraints.
}

Also, the following objects are intended for illustrating expected data structures.
\itemize{
  \item \code{itempool_reading_data} A \code{\link{data.frame}} containing item parameters.
  \item \code{itemattrib_reading_data} A \code{\link{data.frame}} containing item attributes.
  \item \code{stimattrib_reading_data} A \code{\link{data.frame}} containing stimulus attributes.
  \item \code{constraints_reading_data} A \code{\link{data.frame}} containing constraint specifications.
}
}
\examples{
itempool_reading    <- loadItemPool(itempool_reading_data)
itemattrib_reading  <- loadItemAttrib(itemattrib_reading_data, itempool_reading)
stimattrib_reading  <- loadStAttrib(stimattrib_reading_data, itemattrib_reading)
constraints_reading <- loadConstraints(constraints_reading_data,
  itempool_reading, itemattrib_reading, stimattrib_reading)

}
\keyword{datasets}
