% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/shadow_functions.R
\docType{methods}
\name{Shadow}
\alias{Shadow}
\alias{Shadow,item_pool-method}
\title{Run computerized adaptive testing with generalized shadow-test approach}
\usage{
Shadow(object, config, true_theta = NULL, constraints = NULL,
  prior = NULL, prior_par = NULL, data = NULL, session = NULL)

\S4method{Shadow}{item_pool}(object, config, true_theta = NULL,
  constraints = NULL, prior = NULL, prior_par = NULL, data = NULL,
  session = NULL)
}
\arguments{
\item{object}{An \code{\linkS4class{item_pool}} object. Use \code{\link{loadItemPool}} for this.}

\item{config}{A \code{\linkS4class{config_Shadow}} object.}

\item{true_theta}{Numeric. A vector of true theta values to be used in simulation.}

\item{constraints}{A list representing optimization constraints. Use \code{\link{loadConstraints}} for this.}

\item{prior}{Numeric. A matrix or a vector containing priors.}

\item{prior_par}{Numeric. A vector of parameters for prior distribution.}

\item{data}{Numeric. A matrix containing item response data.}

\item{session}{Used to communicate with a Shiny session.}
}
\description{
Run computerized adaptive testing with generalized shadow-test approach.
}
\examples{
object <- itempool_science
config <- createShadowTestConfig()
true_theta <- rnorm(1)
solution <- Shadow(itempool_science, config, true_theta, constraints_science)
solution$output
}
\references{
{
  \insertRef{van_der_linden_model_1998}{TestDesign}

  \insertRef{van_der_linden_optimal_1998}{TestDesign}

  \insertRef{van_der_linden_optimal_2000}{TestDesign}

  \insertRef{van_der_linden_linear_2005}{TestDesign}
}
}
