% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/FwerMethodsSD.R
\name{maxTinftyCor_SD}
\alias{maxTinftyCor_SD}
\title{Multiple testing method of Drton & Perlman (2007) for correlations, with stepdown procedure.}
\usage{
maxTinftyCor_SD(data, alpha = 0.05, stat_test = "empirical",
  Nboot = 1000, OmegaChap = covDcorNorm(cor(data), stat_test),
  vect = FALSE)
}
\arguments{
\item{data}{matrix of observations}

\item{alpha}{level of multiple testing}

\item{stat_test}{\describe{
  \item{'empirical'}{\eqn{\sqrt{n}*abs(corr)}}
  \item{'fisher'}{   \eqn{\sqrt{n-3}*1/2*\log( (1+corr)/(1-corr) )}}
  \item{'student'}{  \eqn{\sqrt{n-2}*abs(corr)/\sqrt(1-corr^2)}}
}
Notice that 'gaussian' is not available.}

\item{Nboot}{number of iterations for Monte-Carlo quantile evaluation}

\item{OmegaChap}{matrix of covariance of test statistics;
optional, useful for oracle estimation and step-down}

\item{vect}{if TRUE returns a vector of TRUE/FALSE values, corresponding to \code{vectorize(cor(data))};
if FALSE, returns an array containing rows and columns of significative correlations}
}
\value{
Returns \itemize{\item{a vector of logicals, equal to TRUE if the corresponding element of the statistic vector is rejected, if \code{vect=TRUE},} \item{a vector containing indexes \eqn{\lbrace(i,j),\,i<j\rbrace} for which correlation between variables \eqn{i} and \eqn{j} is significative, if \code{vect=FALSE}.}}
}
\description{
Multiple testing method based on the evaluation of quantile by simulation of observations 
from the asymptotic distribution (Drton & Perlman (2007)), 
with stepdown procedure.
}
\examples{
 
n <- 100
p <- 10
corr_theo <- diag(1,p)
data <- MASS::mvrnorm(n,rep(0,p),corr_theo)
alpha <- 0.05
res <- maxTinftyCor_SD(data,alpha,stat_test='empirical',Nboot=1000)
}
\references{
Drton, M., & Perlman, M. D. (2007). Multiple testing and error control in Gaussian graphical model selection. Statistical Science, 22(3), 430-449.

Roux, M. (2018). Graph inference by multiple testing with application to Neuroimaging, Ph.D., Université Grenoble Alpes, France, https://tel.archives-ouvertes.fr/tel-01971574v1.
}
\seealso{
ApplyFwerCor, maxTinftyCor
}
