% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MCIS.R
\name{MC_IS}
\alias{MC_IS}
\title{MonteCarlo Simulation with importance sampling}
\usage{
MC_IS(
  lsf,
  lDistr,
  cov_user = 0.05,
  n_batch = 16,
  n_max = 1e+06,
  use_threads = 8,
  sys_type = "parallel",
  dataRecord = TRUE,
  beta_l = 100,
  densityType = "norm",
  dps = NULL,
  debug.level = 0
)
}
\arguments{
\item{lsf}{objective function with limit state function in form of function(x) {x[1]+x[2]...}}

\item{lDistr}{Distributions in input space}

\item{cov_user}{The Coefficent of variation the simulation should reach}

\item{n_batch}{Size per batch for parallel computing}

\item{n_max}{maximum of iteration the MC should do - its like a stop criterion}

\item{use_threads}{determine how many threads to split the work (1=singlecore, 2^n = multicore)}

\item{sys_type}{Determine if parallel or serial system (in case MCIS calculates a system)}

\item{dataRecord}{If True all single steps are recorded and available in the results file afteron}

\item{beta_l}{In Systemcalculation: LSF´s with beta higher than beta_l wont be considered}

\item{densityType}{determines what distributiontype should be taken for the h() density}

\item{dps}{Vector of design points that sould be taken instead of the result of a FORM analysis}

\item{debug.level}{If 0 no additional info if 2 high output during calculation}
}
\value{
The results will be provided within a list with the following objects. Acess them with "$"-accessor

pf probablity of failure

pf_FORM probablity of failure of the FORM Algorithm

var variation

cov_mc coefficent of the monteCarlo

n_mc number of iterations done
}
\description{
Method to calculate failure probability for structural engineering using a simulation method with
importance sampling (a method to reduce the amount of needed samples)
}
\references{
DITLEVSEN O, MADSEN H. Structural reliability methods, vol. 178. New York: Wiley; 1996.

Spaethe, G.: Die Sicherheit tragender Baukonstruktionen, 2. Aufl. Wien: Springer, 1991. – ISBN 3-211-82348-4
}
\author{
(C) 2021 - K. Nille-Hauf, T. Feiri, M. Ricker - Hochschule Biberach, Institut fuer Konstruktiven Ingenieurbau
}
