% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/TempleMetrics.R
\name{Fycondx}
\alias{Fycondx}
\title{Fycondx}
\usage{
Fycondx(y, drobj, xdf)
}
\arguments{
\item{y}{a particular value of y for F(y|x)}

\item{drobj}{a distribution regression object}

\item{xdf}{a dataframe (can contain multiple rows) with x values}
}
\value{
F(y|x) for each value of x passed in
}
\description{
take a particular value of y and predict F(y|x)
}
\examples{
data(igm)
yvals <- seq(quantile(igm$lcfincome,.05,type=1),
 quantile(igm$lcfincome,.95, type=1), length.out=100)
dres <- distreg(lcfincome ~ lfincome + HEDUC, igm, yvals)
xdf <- data.frame(lfincome=10, HEDUC="LessHS")
y0 <- yvals[50]
Fycondx(y0, dres, xdf)

}
