% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bib_parser.R
\name{bib_parser}
\alias{bib_parser}
\alias{fread_bib}
\alias{bib2DT}
\alias{reorder_bib}
\title{Functions for parsing .bib files}
\usage{
fread_bib(
  file.bib,
  check.dup.keys = TRUE,
  strip.braces = TRUE,
  check.unescaped.percent = TRUE,
  .bib_expected = TRUE,
  halt = TRUE,
  rstudio = FALSE,
  .report_error
)

bib2DT(file.bib, to_sort = FALSE)

reorder_bib(file.bib, outfile.bib = file.bib)
}
\arguments{
\item{file.bib}{\code{.bib} file.}

\item{check.dup.keys}{If \code{TRUE}, the default, return error if any bib keys are duplicates.}

\item{strip.braces}{If \code{TRUE}, the default, braces in fields are removed.}

\item{check.unescaped.percent}{If \code{TRUE}, the default, fields with unescaped
percent signs are an error. (Unescaped percent signs in URLs are permitted.) Set
to \code{FALSE} to skip this check.}

\item{.bib_expected}{(logical, default: \code{TRUE}) Should \code{file.bib} be expected to 
have file extension \code{.bib}? If expectation violated, a warning is emitted.}

\item{halt}{Whether to halt on error. If \code{NULL}, the default, the value
\code{getOption("TeXCheckR.halt_on_error")} is used. Otherwise, \code{TRUE} or
\code{FALSE} to halt
regardless of the value of the option.}

\item{rstudio}{(logical, default: \code{FALSE}) If \code{TRUE}, pop the RStudio session
to the location in \code{file.bib} of the first error.}

\item{.report_error}{A function like \code{\link{report2console}} to handle errors.}

\item{to_sort}{Include only author, title, year, and date.}

\item{outfile.bib}{File to write the reordered bib to. Defaults to \code{file.bib}.}
}
\description{
Functions for parsing .bib files
}
\details{
\code{bib2DT} returns a \code{data.table} of the entries in \code{file.bib}. The function
\code{reorder_bib} rewrites \code{file.bib}, to put it in surname, year, title, line number order.
}
