% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nth_arg_positions.R
\name{argument_parsing}
\alias{argument_parsing}
\alias{replace_nth_LaTeX_argument}
\alias{nth_arg_positions}
\title{Replace nth arguments}
\usage{
replace_nth_LaTeX_argument(tex_lines, command_name, n = 1L,
  replacement = "correct", warn = TRUE, .dummy_replacement = "Qq")

nth_arg_positions(tex_lines, command_name, n = 1L)
}
\arguments{
\item{tex_lines}{A character vector of a LaTeX file read in from readLines.}

\item{command_name}{The command name, 
or the pattern of the command, without the initial backslash.}

\item{n}{The number of mandatory arguments.}

\item{replacement}{What to replace the \code{n}th argument with.}

\item{warn}{If the nth argument is not present, emit a warning? Set to \code{FALSE} for n-ary commands.}

\item{.dummy_replacement}{An intermediate replacement value.
This value cannot be present in \code{tex_lines}.}
}
\description{
Replace nth arguments
}
\details{
\code{nth_arg_positions} reports the starts and stops of the command for every line.
This includes the braces (in order to accommodate instances where the argument is empty).
}
\examples{
nth_arg_positions("This is a \\\\textbf{strong} statement.", "textbf")
replace_nth_LaTeX_argument("This is a \\\\textbf{strong} statement.", "textbf")

}
