% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Trees.R
\name{check_monotonicity}
\alias{check_monotonicity}
\title{monotonicity check for taper curve}
\usage{
check_monotonicity(obj, Rfn = NULL)
}
\arguments{
\item{obj}{object of class 'tprTrees'}

\item{Rfn}{Rfn setting for residuals error matrix, defaults to
\code{list(fn="sig2")}, see \code{\link[TapeR]{resVar}}.}
}
\value{
vector of logicals, same length as \code{spp}.
}
\description{
monotonicity check for taper curve
}
\details{
Taper curves are required to decrease monotonically. To avoid the
evaluation of non-monotone taper curves, a check is done through the
constructor function and an indicator (\code{monotone}) is set for each tree
stored inside the \code{tprTrees}-class. As the data has been check on validity
before this function is applied, we can use the tpr*-functions to evaluate
the taper curve and its monotonicity.
The check is done via comparison of the expected diameters along the trunk in
1m-steps and its sorted (monotonically decreasing) version using
\code{\link{identical}}.
}
